/*
 * Decompiled with CFR 0.152.
 */
package com.steveh259.shulkerboxlabels.common.custom_transformations;

import com.steveh259.shulkerboxlabels.common.CommonClient;
import com.steveh259.shulkerboxlabels.common.render.utils.RenderBypass;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

public class CustomItemTransformations {
    boolean calculateDynamicBlockOffset = true;
    boolean treatAsBlock = false;
    private final float[] scales = new float[3];
    private int topHeightOverflow = 0;
    private final float[][][] translations = new float[3][3][2];
    private final float[][][] rotations = new float[3][3][2];

    private float get(float[][][] someArr, Direction.Axis axis, Perspective perspective, RenderBypass bypass) {
        if (!perspective.equals((Object)Perspective.GUI)) {
            return someArr[axis.ordinal()][perspective.ordinal()][0];
        }
        if (bypass != null) {
            return someArr[axis.ordinal()][perspective.ordinal()][bypass.isFlat() || bypass.isFlatLarge() ? 1 : 0];
        }
        return someArr[axis.ordinal()][perspective.ordinal()][((String)CommonClient.config.renderFlat.get()).equalsIgnoreCase("disabled") ? Mode.REGULAR.ordinal() : Mode.FLAT.ordinal()];
    }

    private CustomItemTransformations set(float[][][] someArr, Direction.Axis axis, @Nullable Perspective perspective, @Nullable Mode mode, float value) {
        for (int i = 0; i < Perspective.values().length; ++i) {
            if (perspective != null && i != perspective.ordinal()) continue;
            for (int j = 0; j < Mode.values().length; ++j) {
                if (mode != null && j != mode.ordinal()) continue;
                someArr[axis.ordinal()][i][j] = value;
            }
        }
        return this;
    }

    public CustomItemTransformations translation(Direction.Axis axis, float value) {
        return this.set(this.translations, axis, null, null, value);
    }

    public CustomItemTransformations translation(Direction.Axis axis, Perspective perspective, float value) {
        return this.set(this.translations, axis, perspective, null, value);
    }

    public CustomItemTransformations translation(Direction.Axis axis, Mode mode, float value) {
        return this.set(this.translations, axis, null, mode, value);
    }

    public CustomItemTransformations translation(Direction.Axis axis, Perspective perspective, Mode mode, float value) {
        return this.set(this.translations, axis, perspective, mode, value);
    }

    public CustomItemTransformations rotation(Direction.Axis axis, float value) {
        return this.set(this.rotations, axis, null, null, value);
    }

    public CustomItemTransformations rotation(Direction.Axis axis, Perspective perspective, float value) {
        return this.set(this.rotations, axis, perspective, null, value);
    }

    public CustomItemTransformations rotation(Direction.Axis axis, Mode mode, float value) {
        return this.set(this.rotations, axis, null, mode, value);
    }

    public CustomItemTransformations rotation(Direction.Axis axis, Perspective perspective, Mode mode, float value) {
        return this.set(this.rotations, axis, perspective, mode, value);
    }

    public float getTranslation(Direction.Axis axis, Perspective perspective, RenderBypass bypass) {
        return this.get(this.translations, axis, perspective, bypass);
    }

    public float getTranslation(Direction.Axis axis, Perspective perspective) {
        return this.getTranslation(axis, perspective, null);
    }

    public float getRotation(Direction.Axis axis, Perspective perspective, RenderBypass bypass) {
        return this.get(this.rotations, axis, perspective, bypass);
    }

    public float getRotation(Direction.Axis axis, Perspective perspective) {
        return this.getRotation(axis, perspective, null);
    }

    public float getScale(Perspective perspective) {
        return this.scales[perspective.ordinal()];
    }

    public CustomItemTransformations scale(@Nullable Perspective perspective, float value) {
        if (perspective == null) {
            for (int i = 0; i < Perspective.values().length; ++i) {
                this.scales[i] = value;
            }
        } else {
            this.scales[perspective.ordinal()] = value;
        }
        return this;
    }

    public CustomItemTransformations treatAsBlock(boolean treatAsBlock) {
        this.treatAsBlock = treatAsBlock;
        return this;
    }

    public CustomItemTransformations treatAsBlock() {
        return this.treatAsBlock(true);
    }

    public CustomItemTransformations topHeightOverflow(int overflow) {
        this.topHeightOverflow = overflow;
        return this;
    }

    public int getTopHeightOverflow() {
        return this.topHeightOverflow;
    }

    public boolean isTreatAsBlock() {
        return this.treatAsBlock;
    }

    public boolean shouldCalculateDynamicBlockOffset() {
        return this.calculateDynamicBlockOffset;
    }

    public CustomItemTransformations disableDynamicBlockOffsetCalculation() {
        this.calculateDynamicBlockOffset = false;
        return this;
    }

    public static enum Perspective {
        GUI,
        FirstPersonHands,
        World;

    }

    public static enum Mode {
        REGULAR,
        FLAT;

    }
}

