/*
 * Decompiled with CFR 0.152.
 */
package com.steveh259.shulkerboxlabels.common.render;

import com.steveh259.shulkerboxlabels.common.CommonClient;
import com.steveh259.shulkerboxlabels.common.cache.ShulkerBoxBlockEntityEntry;
import com.steveh259.shulkerboxlabels.common.utils.DataComponentUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class LabelRenderer {
    @Nullable
    public static ShulkerBoxBlockEntityEntry updateBlockEntityCache(ShulkerBoxBlockEntity be) {
        if (!((Boolean)CommonClient.config.renderLabels.get()).booleanValue()) {
            return null;
        }
        ShulkerBoxBlockEntityEntry cacheItem = CommonClient.cache.getShulkerBoxBlockEntityEntry(be);
        if (cacheItem != null && !cacheItem.isLabelFacingOptimistic) {
            cacheItem.resetTime();
            return cacheItem;
        }
        boolean outdated = CommonClient.isOldModIdServerSide();
        Direction blockFacing = be.getBlockState().getOptionalValue((Property)ShulkerBoxBlock.FACING).orElse(Direction.UP);
        Direction labelFacing = outdated ? DataComponentUtils.getFacingOld((BlockEntity)be) : DataComponentUtils.getFacing((BlockEntity)be);
        ItemStack label = outdated ? DataComponentUtils.getLabelOld((BlockEntity)be, (Level)Minecraft.getInstance().level) : DataComponentUtils.getLabel((BlockEntity)be, (Level)Minecraft.getInstance().level);
        ShulkerBoxBlockEntityEntry putCacheItem = new ShulkerBoxBlockEntityEntry(label, blockFacing);
        if (blockFacing.equals((Object)Direction.UP) || blockFacing.equals((Object)Direction.DOWN)) {
            if (labelFacing == null) {
                Direction optimisticFacing = CommonClient.cache.getOptimisticFacing(be.getBlockPos());
                if (optimisticFacing == null) {
                    return null;
                }
                putCacheItem.isLabelFacingOptimistic = true;
                putCacheItem.labelFacing = optimisticFacing;
            } else {
                putCacheItem.isLabelFacingOptimistic = false;
                CommonClient.cache.removeOptimisticFacing(be.getBlockPos());
                putCacheItem.labelFacing = labelFacing;
            }
        }
        if (label == null) {
            return null;
        }
        CommonClient.cache.putShulkerBoxBlockEntityEntry(be, putCacheItem);
        return putCacheItem;
    }
}

