/*
 * Decompiled with CFR 0.152.
 */
package com.steveh259.shulkerboxlabels.common.render.configscreen.components;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.steveh259.shulkerboxlabels.common.render.configscreen.components.GuiComponent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.SubmitNodeStorage;
import net.minecraft.client.renderer.feature.FeatureRenderDispatcher;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.TrackingItemStackRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class HotbarComponent
extends GuiComponent<HotbarComponent> {
    private final HotbarSlot[] slots = new HotbarSlot[3];
    private boolean centerVertical = false;
    private final int absoluteX;
    private final int absoluteY;

    public HotbarComponent(int absoluteX, int absoluteY, int x, int y, float scale) {
        super(x, y, scale);
        this.absoluteX = absoluteX;
        this.absoluteY = absoluteY;
    }

    public HotbarComponent centerVertical() {
        this.centerVertical = true;
        return this;
    }

    public void renderTexture(GuiGraphics guiGraphics) {
        int x = this.absoluteX + this.x;
        int y = this.absoluteY + this.y;
        if (this.centerVertical) {
            y -= 11;
        }
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().setTranslation((float)x, (float)y);
        guiGraphics.enableScissor(0, 0, this.scissorWidth >= 0 ? this.scissorWidth : Math.round(182.0f * this.scale), this.scissorHeight >= 0 ? this.scissorHeight : Math.round(22.0f * this.scale));
        guiGraphics.pose().scale(this.scale);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/hud/hotbar.png"), 0, 0, 0.0f, 0.0f, 182, 22, 182, 22, -1);
        guiGraphics.disableScissor();
        guiGraphics.pose().popMatrix();
    }

    public void renderSlots(PoseStack poseStack, MultiBufferSource multiBufferSource) {
        for (int i = 0; i < this.slots.length; ++i) {
            HotbarSlot curr = this.slots[i];
            if (curr == null) continue;
            poseStack.pushPose();
            poseStack.translate((float)this.x, (float)(-this.y), 100.0f);
            if (this.centerVertical) {
                poseStack.translate(0.0f, 11.0f, 0.0f);
            }
            poseStack.scale(this.scale, -this.scale, this.scale);
            curr.render(poseStack, multiBufferSource, i);
            poseStack.popPose();
        }
    }

    public HotbarComponent setSlot(int index, boolean usesBlockLight, ItemStack item) {
        if (index < 0 || index >= this.slots.length) {
            return this;
        }
        this.slots[index] = new HotbarSlot(item, usesBlockLight);
        return this;
    }

    private record HotbarSlot(ItemStack item, boolean usesBlockLight) {
        private void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int index) {
            if (this.item == null || this.item.isEmpty()) {
                return;
            }
            poseStack.translate(1.0 + 20.0 * ((double)index + 0.5), 11.0, 0.0);
            Minecraft.getInstance().gameRenderer.getLighting().setupFor(this.usesBlockLight ? Lighting.Entry.ITEMS_3D : Lighting.Entry.ITEMS_FLAT);
            poseStack.pushPose();
            poseStack.scale(16.0f, -16.0f, 16.0f);
            this.renderItem(poseStack);
            poseStack.popPose();
            Minecraft.getInstance().renderBuffers().bufferSource().endBatch();
        }

        private void renderItem(PoseStack poseStack) {
            FeatureRenderDispatcher featureRenderDispatcher = Minecraft.getInstance().gameRenderer.getFeatureRenderDispatcher();
            SubmitNodeStorage submitNodeStorage = featureRenderDispatcher.getSubmitNodeStorage();
            TrackingItemStackRenderState x = new TrackingItemStackRenderState();
            Minecraft.getInstance().getItemModelResolver().updateForTopItem((ItemStackRenderState)x, this.item, ItemDisplayContext.GUI, null, null, 0);
            x.submit(poseStack, (SubmitNodeCollector)submitNodeStorage, 0xF000F0, OverlayTexture.NO_OVERLAY, 0);
            featureRenderDispatcher.renderAllFeatures();
        }
    }
}

