/*
 * Decompiled with CFR 0.152.
 */
package com.steveh259.shulkerboxlabels.common.render.configscreen.previews;

import com.mojang.blaze3d.vertex.PoseStack;
import com.steveh259.shulkerboxlabels.common.CommonClient;
import com.steveh259.shulkerboxlabels.common.render.configscreen.components.HotbarComponent;
import com.steveh259.shulkerboxlabels.common.render.configscreen.components.ShulkerInventoryComponent;
import com.steveh259.shulkerboxlabels.common.render.pip.CustomPiPRenderState;
import com.steveh259.shulkerboxlabels.common.render.utils.RenderBypass;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class ContainerPreviews {
    private static void hotbarConsumers(GuiGraphics guiGraphics, int x, int y, int w, int h, BiConsumer<HotbarComponent, Integer> consumer) {
        HotbarComponent[] hotbars = new HotbarComponent[2];
        int edgeDistance = 4;
        for (int i = 0; i < hotbars.length; ++i) {
            hotbars[i] = ((HotbarComponent)new HotbarComponent(x, y, (w / 2 + edgeDistance) * i, h / 2 - 3, 1.15f).scissorWidth(w / 2 - edgeDistance * 2)).centerVertical();
            consumer.accept(hotbars[i], i);
        }
        ContainerPreviews.renderHotbars(guiGraphics, x, y, w, h, hotbars);
    }

    private static void renderHotbars(GuiGraphics guiGraphics, int x, int y, int w, int h, HotbarComponent[] hotbars) {
        for (HotbarComponent hotbar : hotbars) {
            hotbar.renderTexture(guiGraphics);
        }
        guiGraphics.guiRenderState.submitPicturesInPictureState((PictureInPictureRenderState)new CustomPiPRenderState(x, y, w, h).draw((poseStack, multiBufferSource) -> {
            for (HotbarComponent hotbar : hotbars) {
                hotbar.renderSlots((PoseStack)poseStack, (MultiBufferSource)multiBufferSource);
            }
        }));
    }

    public static void drawHotbarFlatPreview(GuiGraphics guiGraphics, int x, int y, int w, int h) {
        ContainerPreviews.hotbarConsumers(guiGraphics, x, y, w, h, (hotbar, i) -> hotbar.setSlot(0, i == 1, new RenderBypass().flat(i == 0).flatLarge((Boolean)CommonClient.config.renderFlatLarge.get()).gui().iso(((String)CommonClient.config.labelRenderingModeGUI.get()).equalsIgnoreCase("iso")).toItemStack(Blocks.LIGHT_BLUE_SHULKER_BOX, Items.OAK_LOG)).setSlot(1, i == 1, new RenderBypass().flat(i == 0).flatLarge((Boolean)CommonClient.config.renderFlatLarge.get()).gui().iso(((String)CommonClient.config.labelRenderingModeGUI.get()).equalsIgnoreCase("iso")).toItemStack(Blocks.RED_SHULKER_BOX, Items.ANVIL)));
    }

    public static void drawHotbarLargeFlatPreview(GuiGraphics guiGraphics, int x, int y, int w, int h) {
        ContainerPreviews.hotbarConsumers(guiGraphics, x, y, w, h, (hotbar, i) -> hotbar.setSlot(0, false, new RenderBypass().flat().flatLarge(i == 0).gui().iso(((String)CommonClient.config.labelRenderingModeGUI.get()).equalsIgnoreCase("iso")).toItemStack(Blocks.LIGHT_BLUE_SHULKER_BOX, Items.OAK_LOG)).setSlot(1, false, new RenderBypass().flat().flatLarge(i == 0).gui().iso(((String)CommonClient.config.labelRenderingModeGUI.get()).equalsIgnoreCase("iso")).toItemStack(Blocks.RED_SHULKER_BOX, Items.ANVIL)));
    }

    public static void drawLabelModesGUIPreview(GuiGraphics guiGraphics, int x, int y, int w, int h) {
        boolean flat = List.of("enabled", "onlyLabeled").contains(CommonClient.config.renderFlat.get());
        ContainerPreviews.hotbarConsumers(guiGraphics, x, y, w, h, (hotbar, i) -> hotbar.setSlot(0, !flat, new RenderBypass().flat(flat).flatLarge((Boolean)CommonClient.config.renderFlatLarge.get()).gui().iso(i == 0).toItemStack(Blocks.LIGHT_BLUE_SHULKER_BOX, Items.OAK_LOG)).setSlot(1, !flat, new RenderBypass().flat(flat).flatLarge((Boolean)CommonClient.config.renderFlatLarge.get()).gui().iso(i == 0).toItemStack(Blocks.RED_SHULKER_BOX, Items.ANVIL)));
    }

    public static void drawShulkerBoxIconPreview(GuiGraphics guiGraphics, int w) {
        for (int i = 0; i < 2; ++i) {
            ShulkerInventoryComponent inv = (ShulkerInventoryComponent)new ShulkerInventoryComponent((w / 2 + 4) * i, 0, 0.7f).scissorWidth(w / 2 - (i == 0 ? 4 : 0));
            if (i == 0) {
                inv.setIcon(new ItemStack((ItemLike)Items.GLOW_BERRIES));
            }
            inv.render(guiGraphics);
        }
    }
}

