/*
 * Decompiled with CFR 0.152.
 */
package com.steveh259.shulkerboxlabels.common.render.ui;

import com.steveh259.shulkerboxlabels.common.render.ui.LayoutItemButton;
import com.steveh259.shulkerboxlabels.common.render.ui.LayoutItemCheckbox;
import com.steveh259.shulkerboxlabels.common.render.ui.LayoutItemCyclingButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.network.chat.Component;

public class InternalLayoutItemButtonExtended
extends Button {
    private Component text;
    private final LayoutItemButton layoutItemButton;
    private int backgroundColor = 0;

    protected InternalLayoutItemButtonExtended(int x, int y, int width, int height, Component text, Button.OnPress onPress, LayoutItemButton layoutItemButton) {
        super(x, y, width, height, text, onPress, Button.DEFAULT_NARRATION);
        this.text = text;
        this.layoutItemButton = layoutItemButton;
    }

    protected void renderWidget(GuiGraphics context, int mouseX, int mouseY, float deltaTicks) {
        if (this.getX() != this.layoutItemButton.getX()) {
            this.setX(this.layoutItemButton.getX());
        }
        if (this.getY() != this.layoutItemButton.getY()) {
            this.setY(this.layoutItemButton.getY());
        }
        if (this.getWidth() != this.layoutItemButton.getWidth()) {
            this.setWidth(this.layoutItemButton.getWidth());
        }
        if (this.getHeight() != this.layoutItemButton.getHeight()) {
            this.setHeight(this.layoutItemButton.getHeight());
        }
        if (this.backgroundColor != 0) {
            context.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), this.backgroundColor);
        }
        if (this.isHovered()) {
            context.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), -2013265920);
        }
        InternalLayoutItemButtonExtended.renderScrollingString((GuiGraphics)context, (Font)Minecraft.getInstance().font, (Component)this.text, (int)(this.getX() + this.getWidth() / 2), (int)this.getX(), (int)this.getY(), (int)(this.getX() + this.getWidth()), (int)(this.getY() + this.getHeight()), (int)-1);
        if (this.isFocused()) {
            context.submitOutline(this.getX(), this.getY(), this.getWidth(), this.getHeight(), -1);
        }
    }

    public void onPress(InputWithModifiers inputWithModifiers) {
        super.onPress(inputWithModifiers);
        this.onPressHandler();
    }

    private void onPressHandler() {
        this.layoutItemButton.getPressAction().onPress((Button)this);
        LayoutItemButton layoutItemButton = this.layoutItemButton;
        if (layoutItemButton instanceof LayoutItemCheckbox) {
            LayoutItemCheckbox cb = (LayoutItemCheckbox)layoutItemButton;
            cb.toggle();
        } else {
            layoutItemButton = this.layoutItemButton;
            if (layoutItemButton instanceof LayoutItemCyclingButton) {
                LayoutItemCyclingButton cb = (LayoutItemCyclingButton)layoutItemButton;
                cb.cycle();
            }
        }
    }

    public void setText(Component text) {
        this.text = text;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }
}

