/*
 * Decompiled with CFR 0.152.
 */
package com.steveh259.shulkerboxlabels.common.render.ui;

import com.steveh259.shulkerboxlabels.common.config.ConfigScreen;
import com.steveh259.shulkerboxlabels.common.render.ui.ConfigListItemDrawConsumer;
import com.steveh259.shulkerboxlabels.common.render.ui.LayoutItemButton;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;

public class LayoutItem<T extends LayoutItem<T>>
implements Renderable {
    private T parent;
    private String debugId = "";
    private int x = 0;
    private int y = 0;
    protected int width = 0;
    protected int height = 0;
    private int backgroundColor = 0;
    protected int horizontalPadding = 0;
    protected int verticalPadding = 0;
    private boolean dynamicWidth = false;
    private boolean dynamicHeight = false;
    private float widthPercentage = -1.0f;
    private float heightPercentage = -1.0f;
    private boolean horizontalLayout = false;
    private int borderWidth = 0;
    private int borderColor = 0;
    private final List<LayoutItem<T>> children = new ArrayList<LayoutItem<T>>();
    private ConfigListItemDrawConsumer<GuiGraphics, Integer, Integer, Integer, Integer, Float> drawing;
    private ConfigScreen parentScreen;
    private boolean hidden = false;
    private boolean scissor = true;
    private int verticalOverflowDistance = -1;

    public void render(GuiGraphics context, int mouseX, int mouseY, float deltaTicks) {
        if (this.isHidden()) {
            return;
        }
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        if (this.getScissor()) {
            context.enableScissor(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight());
        }
        this.drawBackground(context);
        this.drawBorder(context);
        if (this.drawing != null) {
            context.pose().pushMatrix();
            context.pose().translate((float)(this.getX() + this.getHorizontalPadding()), (float)(this.getY() + this.getVerticalPadding()));
            this.drawing.accept(context, this.getX(), this.getY(), this.getWidth(), this.getHeight(), Float.valueOf(deltaTicks));
            context.pose().popMatrix();
        }
        if (this.getScissor()) {
            context.disableScissor();
        }
    }

    public T draw(ConfigListItemDrawConsumer<GuiGraphics, Integer, Integer, Integer, Integer, Float> consumer) {
        this.drawing = consumer;
        return (T)this;
    }

    public void drawBackground(GuiGraphics context) {
        if (this.getBackgroundColor() != 0) {
            context.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), this.getBackgroundColor());
        }
    }

    public void drawBorder(GuiGraphics context) {
        if (this.borderWidth > 0 && this.borderColor != 0) {
            for (int i = 0; i < this.borderWidth; ++i) {
                context.submitOutline(this.getX() + i, this.getY() + i, this.getWidth() - i * 2, this.getHeight() - i * 2, this.getBorderColor());
            }
        }
    }

    public T attachScreen(ConfigScreen parentScreen) {
        if (this instanceof LayoutItemButton) {
            parentScreen.addRenderableWidget(((LayoutItemButton)this).getButtonWidget());
        } else {
            parentScreen.addRenderableOnly(this);
        }
        for (LayoutItem<T> curr : this.children) {
            curr.attachScreen(parentScreen);
        }
        return (T)this;
    }

    public LayoutItem children(LayoutItem ... children) {
        for (LayoutItem curr : children) {
            if (curr == null) continue;
            curr.setParent(this);
            this.children.add(curr);
        }
        return this;
    }

    public List<LayoutItem<T>> getChildren() {
        return this.children;
    }

    public ConfigScreen getParentScreen() {
        return this.parentScreen;
    }

    public void setParentScreen(ConfigScreen parentScreen) {
        this.parentScreen = parentScreen;
    }

    public void setParentScreenFromParent() {
        if (this.getParentScreen() != null) {
            return;
        }
        for (T parentItem = this.getParent(); parentItem != null; parentItem = ((LayoutItem)parentItem).getParent()) {
            ConfigScreen p = ((LayoutItem)parentItem).getParentScreen();
            if (p == null) continue;
            this.setParentScreen(p);
            break;
        }
    }

    private LayoutItem<T> getPreviousSibling() {
        if (this.getParent() == null) {
            return null;
        }
        int i = ((LayoutItem)this.getParent()).getChildren().indexOf(this);
        if (i > 0) {
            return ((LayoutItem)this.getParent()).getChildren().get(i - 1);
        }
        return null;
    }

    public T x(int x) {
        this.x = x;
        return (T)this;
    }

    public int getX() {
        if (this.getParent() != null) {
            LayoutItem<T> elem;
            int leftOffset = 0;
            if (this.getParent() != null && ((LayoutItem)this.getParent()).isHorizontalLayout() && (elem = this.getPreviousSibling()) != null) {
                leftOffset += elem.getX() + elem.getWidth() - (((LayoutItem)this.getParent()).getX() + ((LayoutItem)this.getParent()).getHorizontalPadding());
            }
            return this.x + ((LayoutItem)this.getParent()).getX() + ((LayoutItem)this.getParent()).getHorizontalPadding() + leftOffset;
        }
        return this.x;
    }

    public T y(int y) {
        this.y = y;
        return (T)this;
    }

    public int getY() {
        if (this.getParent() != null) {
            int topOffset = 0;
            LayoutItem<T> elem = this.getPreviousSibling();
            if (this.getParent() != null && ((LayoutItem)this.getParent()).isVerticalLayout() && elem != null) {
                topOffset += elem.getY() + elem.getHeight() - ((LayoutItem)this.getParent()).getY() - ((LayoutItem)this.getParent()).getVerticalPadding();
            }
            int y = this.y + ((LayoutItem)this.getParent()).getY() + ((LayoutItem)this.getParent()).getVerticalPadding() + topOffset;
            if (this.shouldCheckVerticalOverflow() && y + this.getHeight() + this.verticalOverflowDistance > Minecraft.getInstance().getWindow().getGuiScaledHeight()) {
                y -= y + this.getHeight() - Minecraft.getInstance().getWindow().getGuiScaledHeight() + this.verticalOverflowDistance;
            }
            return y;
        }
        int y = this.y;
        if (this.shouldCheckVerticalOverflow() && y + this.getHeight() + this.verticalOverflowDistance >= Minecraft.getInstance().getWindow().getGuiScaledHeight()) {
            y -= y + this.getHeight() - Minecraft.getInstance().getWindow().getGuiScaledHeight() + this.verticalOverflowDistance;
        }
        return y;
    }

    public T width(int width) {
        this.width = width;
        return (T)this;
    }

    public int getWidth() {
        if (this.isHidden()) {
            return 0;
        }
        if (this.isDynamicWidth()) {
            int w = 0;
            for (LayoutItem<T> curr : this.getChildren()) {
                if (this.isHorizontalLayout()) {
                    w += curr.getWidth();
                    continue;
                }
                w = Math.max(w, curr.getWidth());
            }
            return w + 2 * this.horizontalPadding;
        }
        if (this.getParent() != null && this.getWidthPercentage() != -1.0f) {
            return (int)Math.floor((float)(((LayoutItem)this.getParent()).getWidth() - 2 * ((LayoutItem)this.getParent()).getHorizontalPadding()) * this.getWidthPercentage());
        }
        return this.width;
    }

    public T height(int height) {
        this.height = height;
        return (T)this;
    }

    public int getHeight() {
        if (this.isHidden()) {
            return 0;
        }
        if (this.isDynamicHeight()) {
            int h = 0;
            for (LayoutItem<T> curr : this.getChildren()) {
                if (!this.isHorizontalLayout()) {
                    h += curr.getHeight();
                    continue;
                }
                h = Math.max(h, curr.getHeight());
            }
            return h + 2 * this.verticalPadding;
        }
        if (this.getParent() != null && this.getHeightPercentage() != -1.0f) {
            return (int)Math.floor((float)(((LayoutItem)this.getParent()).getHeight() - 2 * ((LayoutItem)this.getParent()).getVerticalPadding()) * this.getHeightPercentage());
        }
        return this.height;
    }

    public T padding(int padding) {
        this.horizontalPadding(padding);
        this.verticalPadding(padding);
        return (T)this;
    }

    public T horizontalPadding(int padding) {
        this.horizontalPadding += padding;
        return (T)this;
    }

    public int getHorizontalPadding() {
        return this.horizontalPadding + this.borderWidth;
    }

    public T verticalPadding(int padding) {
        this.verticalPadding += padding;
        return (T)this;
    }

    public int getVerticalPadding() {
        return this.verticalPadding + this.borderWidth;
    }

    public T dimensions(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        return (T)this;
    }

    public T backgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
        return (T)this;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public T fullWidth() {
        this.widthPercentage(1.0f);
        return (T)this;
    }

    public boolean isFullWidth() {
        return this.getWidthPercentage() == 1.0f;
    }

    public T fullHeight() {
        this.heightPercentage(1.0f);
        return (T)this;
    }

    public boolean isFullHeight() {
        return this.getHeightPercentage() == 1.0f;
    }

    public T dynamicWidth() {
        this.dynamicWidth = true;
        return (T)this;
    }

    public boolean isDynamicWidth() {
        return this.dynamicWidth;
    }

    public T dynamicHeight() {
        this.dynamicHeight = true;
        return (T)this;
    }

    public boolean isDynamicHeight() {
        return this.dynamicHeight;
    }

    public T horizontalLayout() {
        this.horizontalLayout = true;
        return (T)this;
    }

    public boolean isHorizontalLayout() {
        return this.horizontalLayout;
    }

    public T verticalLayout() {
        this.horizontalLayout = false;
        return (T)this;
    }

    public boolean isVerticalLayout() {
        return !this.horizontalLayout;
    }

    public void setParent(T parent) {
        this.parent = parent;
    }

    public T getParent() {
        return this.parent;
    }

    public T widthPercentage(float scale) {
        this.widthPercentage = scale;
        return (T)this;
    }

    public float getWidthPercentage() {
        return this.widthPercentage;
    }

    public T heightPercentage(float scale) {
        this.heightPercentage = scale;
        return (T)this;
    }

    public float getHeightPercentage() {
        return this.heightPercentage;
    }

    public T debugId(String debugId) {
        this.debugId = debugId;
        return (T)this;
    }

    public String getDebugId() {
        return this.debugId;
    }

    public T borderColor(int borderColor) {
        this.borderColor = borderColor;
        return (T)this;
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public T borderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
        return (T)this;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public T hide() {
        this.hidden = true;
        return (T)this;
    }

    public T hide(boolean hidden) {
        this.hidden = !hidden;
        return (T)this;
    }

    public boolean isHidden() {
        if (this.hidden) {
            return true;
        }
        for (T item = this.getParent(); item != null; item = ((LayoutItem)item).getParent()) {
            if (!((LayoutItem)item).hidden) continue;
            return true;
        }
        return false;
    }

    public T unhide() {
        this.hidden = false;
        return (T)this;
    }

    public T disableScissor() {
        this.scissor = false;
        return (T)this;
    }

    public boolean getScissor() {
        return this.scissor;
    }

    public T protectFromVerticalOverflow(int distance) {
        this.verticalOverflowDistance = distance;
        return (T)this;
    }

    private boolean shouldCheckVerticalOverflow() {
        return this.verticalOverflowDistance >= 0;
    }

    public T addThisToList(List<LayoutItem<?>> list) {
        list.add(this);
        return (T)this;
    }
}

