/*
 * Decompiled with CFR 0.152.
 */
package com.steveh259.shulkerboxlabels.common.render.ui;

import com.steveh259.shulkerboxlabels.common.config.ConfigScreen;
import com.steveh259.shulkerboxlabels.common.render.ui.LayoutItem;
import com.steveh259.shulkerboxlabels.common.render.ui.LayoutItemButton;
import com.steveh259.shulkerboxlabels.common.render.ui.LayoutItemText;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class LayoutItemCheckbox
extends LayoutItemButton {
    private final Component text;
    private final float textWidth = 0.8f;
    private boolean checkable = true;
    private int checkboxColor = -1;
    private Consumer<Boolean> checkedCallback;
    private boolean checked = false;

    public LayoutItemCheckbox(Component text) {
        super((Component)Component.literal((String)""));
        this.text = text;
    }

    public LayoutItemCheckbox checked(boolean checked) {
        this.checked = checked;
        return this;
    }

    public LayoutItemCheckbox onChecked(Consumer<Boolean> checked) {
        this.checkedCallback = checked;
        return this;
    }

    public void toggle() {
        if (!this.isCheckable()) {
            return;
        }
        boolean bl = this.checked = !this.checked;
        if (this.checkedCallback != null) {
            this.checkedCallback.accept(this.checked);
        }
    }

    @Override
    public LayoutItemCheckbox attachScreen(ConfigScreen parentScreen) {
        super.attachScreen(parentScreen);
        ((LayoutItem)((LayoutItem)((LayoutItem)((LayoutItem)((LayoutItem)((LayoutItem)((LayoutItem)new LayoutItem().x(this.getX())).y(this.getY())).width(this.getWidth())).height(this.getHeight())).horizontalPadding(this.getHorizontalPadding())).verticalPadding(this.getVerticalPadding())).horizontalLayout()).children(new LayoutItem[]{((LayoutItemText)((LayoutItemText)new LayoutItemText(this.text).fullHeight()).widthPercentage(0.85f)).centerVertical(), ((LayoutItem)((LayoutItem)new LayoutItem().fullHeight()).widthPercentage(0.15f)).draw((ctx, x, y, width, height, deltaTicks) -> {
            int size = 8;
            int color = this.getCheckboxColor();
            ctx.pose().translate((float)(width - size), (float)(height - size) / 2.0f);
            if (this.checked) {
                ctx.fill(0, 0, size, size, color);
            } else {
                this.drawOutline((GuiGraphics)ctx, size, color);
            }
            if (!this.isCheckable()) {
                ctx.fill(2, 2, size - 2, size - 2, this.getCheckboxColor());
            }
        })}).attachScreen(parentScreen);
        return this;
    }

    private void drawOutline(GuiGraphics guiGraphics, int size, int color) {
        guiGraphics.fill(0, 0, size, 1, color);
        guiGraphics.fill(size - 1, 0, size, size, color);
        guiGraphics.fill(0, size - 1, size, size, color);
        guiGraphics.fill(0, 0, 1, size, color);
    }

    @Override
    public int getHeight() {
        if (this.isDynamicHeight()) {
            Font textRenderer = Minecraft.getInstance().font;
            List lines = textRenderer.split((FormattedText)this.text, (int)Math.floor((float)this.getWidth() * this.textWidth));
            Objects.requireNonNull(textRenderer);
            return 9 * lines.size() + this.getVerticalPadding() * 2;
        }
        return super.getHeight();
    }

    public LayoutItemCheckbox setCheckable(boolean checkable) {
        this.checkable = checkable;
        return this;
    }

    public boolean isCheckable() {
        return this.checkable;
    }

    public LayoutItemCheckbox checkboxColor(int color) {
        this.checkboxColor = color;
        return this;
    }

    public int getCheckboxColor() {
        return this.checkboxColor;
    }
}

