/*
 * Decompiled with CFR 0.152.
 */
package com.steveh259.shulkerboxlabels.common.render.ui;

import com.steveh259.shulkerboxlabels.common.config.ConfigScreen;
import com.steveh259.shulkerboxlabels.common.render.ui.LayoutItem;
import com.steveh259.shulkerboxlabels.common.render.ui.LayoutItemButton;
import com.steveh259.shulkerboxlabels.common.render.ui.LayoutItemCyclingButtonOption;
import com.steveh259.shulkerboxlabels.common.render.ui.LayoutItemText;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class LayoutItemCyclingButton
extends LayoutItemButton {
    private int currentOptionIndex = -1;
    private final List<LayoutItemCyclingButtonOption> options = new ArrayList<LayoutItemCyclingButtonOption>();
    private final int maxTextWidth;
    private final Component buttonLabel;
    private float textWidthPercentage;
    private Consumer<String> stringConsumer;

    public LayoutItemCyclingButton(Component buttonLabel, String initialOption, LayoutItemCyclingButtonOption ... options) {
        super((Component)Component.literal((String)initialOption));
        Collections.addAll(this.options, options);
        this.buttonLabel = buttonLabel;
        this.currentOptionIndex = this.options.stream().map(LayoutItemCyclingButtonOption::getValue).toList().indexOf(initialOption.toLowerCase());
        this.maxTextWidth = this.getMaxTextWidth();
        this.text((Component)Component.literal((String)""));
    }

    @Override
    public LayoutItemCyclingButton attachScreen(ConfigScreen parentScreen) {
        super.attachScreen(parentScreen);
        this.textWidthPercentage = (float)(this.maxTextWidth + this.getHorizontalPadding() * 2) / (float)this.getWidth();
        ((LayoutItem)((LayoutItem)((LayoutItem)((LayoutItem)((LayoutItem)((LayoutItem)((LayoutItem)new LayoutItem().x(this.getX())).y(this.getY())).width(this.getWidth())).height(this.getHeight())).horizontalPadding(this.getHorizontalPadding())).verticalPadding(this.getVerticalPadding())).horizontalLayout()).children(new LayoutItem[]{((LayoutItemText)((LayoutItemText)new LayoutItemText(this.buttonLabel).fullHeight()).widthPercentage(1.0f - this.textWidthPercentage)).centerVertical(), ((LayoutItem)((LayoutItem)((LayoutItem)new LayoutItem().fullHeight()).widthPercentage(this.textWidthPercentage)).disableScissor()).draw((ctx, x, y, w, h, deltaTicks) -> {
            Font textRenderer = Minecraft.getInstance().font;
            ctx.fill(-this.getHorizontalPadding() / 2, -this.getVerticalPadding() / 2, w + this.getHorizontalPadding() / 2, h + this.getVerticalPadding() / 2, 0x11FFFFFF);
            Component component = this.getOptionText();
            int n = w / 2 - textRenderer.width((FormattedText)this.getOptionText()) / 2;
            int n2 = h / 2;
            Objects.requireNonNull(textRenderer);
            ctx.drawString(textRenderer, component, n, n2 - 9 / 2, -1, false);
        })}).attachScreen(parentScreen);
        return this;
    }

    @Override
    public int getHeight() {
        if (this.isDynamicHeight()) {
            Font textRenderer = Minecraft.getInstance().font;
            List lines = textRenderer.split((FormattedText)this.buttonLabel, (int)Math.floor((float)this.getWidth() * this.textWidthPercentage));
            Objects.requireNonNull(textRenderer);
            return 9 * lines.size() + this.getVerticalPadding() * 2;
        }
        return super.getHeight();
    }

    private Component getOptionText() {
        if (this.currentOptionIndex == -1) {
            return Component.literal((String)"");
        }
        return this.options.get(this.currentOptionIndex).getLabel();
    }

    private int getMaxTextWidth() {
        Font textRenderer = Minecraft.getInstance().font;
        int w = 0;
        for (LayoutItemCyclingButtonOption opt : this.options) {
            w = Math.max(w, textRenderer.width((FormattedText)opt.getLabel()));
        }
        return w;
    }

    public void cycle() {
        LayoutItemCyclingButtonOption a;
        ++this.currentOptionIndex;
        if (this.currentOptionIndex >= this.options.size()) {
            this.currentOptionIndex = 0;
        }
        if (this.stringConsumer != null && (a = this.options.get(this.currentOptionIndex)) != null) {
            this.stringConsumer.accept(a.getValue());
        }
    }

    public void setValue(String value) {
        this.currentOptionIndex = this.options.stream().map(LayoutItemCyclingButtonOption::getValue).toList().indexOf(value.toLowerCase());
    }

    public LayoutItemCyclingButton onChange(Consumer<String> val) {
        this.stringConsumer = val;
        return this;
    }
}

