/*
 * Decompiled with CFR 0.152.
 */
package com.steveh259.shulkerboxlabels.common.render.ui;

import com.steveh259.shulkerboxlabels.common.render.ui.LayoutItem;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class LayoutItemText
extends LayoutItem<LayoutItemText> {
    private int color = -1;
    private final Component text;
    private boolean centerVertical = false;
    private boolean centerHorizontal = false;

    public LayoutItemText(Component text) {
        this.text = text;
    }

    public List<FormattedCharSequence> getWrappedLines() {
        Font textRenderer = Minecraft.getInstance().font;
        return textRenderer.split((FormattedText)this.text, this.getWidth());
    }

    @Override
    public void render(GuiGraphics context, int mouseX, int mouseY, float deltaTicks) {
        if (this.isHidden()) {
            return;
        }
        super.render(context, mouseX, mouseY, deltaTicks);
        Font textRenderer = Minecraft.getInstance().font;
        List<FormattedCharSequence> lines = this.getWrappedLines();
        int startX = this.getX();
        int startY = this.getY();
        if (this.centerVertical) {
            int n = this.getHeight() / 2;
            Objects.requireNonNull(textRenderer);
            startY += n - 9 * lines.size() / 2;
        }
        if (this.centerHorizontal) {
            startX += this.getWidth() / 2 - this.getMaxLineWidth(lines) / 2;
        }
        for (int i = 0; i < lines.size(); ++i) {
            FormattedCharSequence line = lines.get(i);
            Objects.requireNonNull(textRenderer);
            context.drawString(textRenderer, line, startX, startY + i * 9, this.color, false);
        }
    }

    private int getMaxLineWidth(List<FormattedCharSequence> lines) {
        Font textRenderer = Minecraft.getInstance().font;
        int maxWidth = 0;
        for (FormattedCharSequence line : lines) {
            maxWidth = Math.max(maxWidth, textRenderer.width(line));
        }
        return maxWidth;
    }

    @Override
    public int getHeight() {
        if (this.isHidden()) {
            return 0;
        }
        if (this.isDynamicHeight()) {
            Font textRenderer = Minecraft.getInstance().font;
            int n = this.getWrappedLines().size();
            Objects.requireNonNull(textRenderer);
            return n * 9;
        }
        LayoutItemText that = this;
        if (this.getParent() != null && this.getHeightPercentage() != -1.0f) {
            return Math.round((float)(((LayoutItem)that.getParent()).getHeight() - 2 * ((LayoutItem)that.getParent()).getVerticalPadding()) * this.getHeightPercentage());
        }
        return this.height - 2 * this.verticalPadding;
    }

    @Override
    public int getWidth() {
        if (this.isHidden()) {
            return 0;
        }
        if (this.isDynamicWidth()) {
            return this.getMaxLineWidth(this.getWrappedLines());
        }
        LayoutItemText that = this;
        if (this.getParent() != null && this.getWidthPercentage() != -1.0f) {
            return Math.round((float)(((LayoutItem)that.getParent()).getWidth() - 2 * ((LayoutItem)that.getParent()).getHorizontalPadding()) * this.getWidthPercentage());
        }
        return this.width - 2 * this.horizontalPadding;
    }

    public LayoutItemText color(int color) {
        this.color = color;
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public LayoutItemText centerHorizontal() {
        this.centerHorizontal = true;
        return this;
    }

    public LayoutItemText centerVertical() {
        this.centerVertical = true;
        return this;
    }
}

