/*
 * Decompiled with CFR 0.152.
 */
package com.steveh259.shulkerboxlabels.common.render.utils;

import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class RenderBypass {
    public static final String customNameKey = "shulker-box-labels$bypassRegularRendering";
    private boolean flat = false;
    private boolean flatLarge = false;
    private boolean gui = false;
    private float rotation = 0.0f;
    private boolean rotateLabel = false;
    private boolean iso = false;

    public RenderBypass flat(boolean value) {
        this.flat = value;
        return this;
    }

    public RenderBypass flat() {
        return this.flat(true);
    }

    public RenderBypass flatLarge(boolean value) {
        this.flatLarge = value;
        return this;
    }

    public RenderBypass flatLarge() {
        return this.flatLarge(true);
    }

    public RenderBypass gui(boolean value) {
        this.gui = value;
        return this;
    }

    public RenderBypass gui() {
        return this.gui(true);
    }

    public RenderBypass rotation(float value) {
        this.rotation = value;
        return this;
    }

    public RenderBypass rotateLabel(boolean value) {
        this.rotateLabel = value;
        return this;
    }

    public RenderBypass rotateLabel() {
        return this.rotateLabel(true);
    }

    public RenderBypass iso(boolean value) {
        this.iso = value;
        return this;
    }

    public RenderBypass iso() {
        return this.iso(true);
    }

    public RenderBypass() {
    }

    private RenderBypass(float rotation, boolean flat, boolean flatLarge, boolean gui, boolean rotateLabel, boolean iso) {
        this.rotation = rotation;
        this.flat = flat;
        this.flatLarge = flatLarge;
        this.gui = gui;
        this.rotateLabel = rotateLabel;
        this.iso = iso;
    }

    public static RenderBypass fromLabelItemStack(ItemStack labelItemStack) {
        if (labelItemStack == null) {
            return null;
        }
        Component customNameText = labelItemStack.getCustomName();
        if (customNameText == null) {
            return null;
        }
        if (!customNameText.getString().equals(customNameKey)) {
            return null;
        }
        CompoundTag customDataNbt = ((CustomData)labelItemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)new CompoundTag()))).copyTag();
        if (customDataNbt.isEmpty()) {
            return null;
        }
        return new RenderBypass(customDataNbt.getFloatOr(RenderBypass.tag("rotation"), 0.0f), customDataNbt.getBooleanOr(RenderBypass.tag("flat"), false), customDataNbt.getBooleanOr(RenderBypass.tag("flatLarge"), false), customDataNbt.getBooleanOr(RenderBypass.tag("gui"), false), customDataNbt.getBooleanOr(RenderBypass.tag("rotateLabel"), false), customDataNbt.getBooleanOr(RenderBypass.tag("iso"), false));
    }

    public ItemStack toItemStack(Block shulkerBoxBlock, Item label) {
        ItemStack itemStack = new ItemStack((ItemLike)shulkerBoxBlock);
        CompoundTag customDataNbt = new CompoundTag();
        CompoundTag labelNbt = new CompoundTag();
        labelNbt.putString(DataComponents.CUSTOM_NAME.toString(), customNameKey);
        if (label != null) {
            labelNbt.putInt("count", 1);
            labelNbt.putString("id", label.toString());
        }
        CompoundTag labelCustomDataNbt = new CompoundTag();
        labelCustomDataNbt.putFloat(RenderBypass.tag("rotation"), this.rotation);
        labelCustomDataNbt.putBoolean(RenderBypass.tag("flat"), this.flat);
        labelCustomDataNbt.putBoolean(RenderBypass.tag("flatLarge"), this.flatLarge);
        labelCustomDataNbt.putBoolean(RenderBypass.tag("gui"), this.gui);
        labelCustomDataNbt.putBoolean(RenderBypass.tag("rotateLabel"), this.rotateLabel);
        labelCustomDataNbt.putBoolean(RenderBypass.tag("iso"), this.iso);
        labelNbt.put(DataComponents.CUSTOM_DATA.toString(), (Tag)labelCustomDataNbt);
        customDataNbt.put("shulker-box-labels:label", (Tag)labelNbt);
        itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)customDataNbt));
        return itemStack;
    }

    private static String tag(String tag) {
        String customDataPrefix = "shulker-box-labels-bypass:";
        return customDataPrefix + tag;
    }

    public float getRotation() {
        return this.rotation;
    }

    public boolean isFlat() {
        return this.flat;
    }

    public boolean isGui() {
        return this.gui;
    }

    public boolean isFlatLarge() {
        return this.flatLarge;
    }

    public boolean shouldRotateLabel() {
        return this.rotateLabel;
    }

    public boolean isIso() {
        return this.iso;
    }
}

