/*
 * Decompiled with CFR 0.152.
 */
package com.steveh259.shulkerboxlabels.common.render.utils;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.steveh259.shulkerboxlabels.common.CommonClient;
import com.steveh259.shulkerboxlabels.common.custom_transformations.CustomItemTransformationMap;
import com.steveh259.shulkerboxlabels.common.custom_transformations.CustomItemTransformations;
import com.steveh259.shulkerboxlabels.common.ducks.IItemStackRenderState;
import com.steveh259.shulkerboxlabels.common.render.utils.RenderBypass;
import com.steveh259.shulkerboxlabels.common.utils.DebugUtils;
import com.steveh259.shulkerboxlabels.common.utils.LabelItemObject;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.TrackingItemStackRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Unique;

public class RenderUtils {
    private static boolean isDebug(Item labelItem) {
        return DebugUtils.isDebugMode() && (float)BuiltInRegistries.ITEM.getId((Object)labelItem) == DebugUtils.getValue("itemIndex");
    }

    public static float getScale(ItemDisplayContext displayContext, Item labelItem, RenderBypass bypass) {
        float scaleWorld;
        boolean debug = RenderUtils.isDebug(labelItem);
        CustomItemTransformations customTransformation = CustomItemTransformationMap.getItemTransformation(labelItem);
        boolean iso = bypass == null && RenderUtils.renderIso(displayContext) || bypass != null && bypass.isIso();
        CustomItemTransformations.Perspective perspective = RenderUtils.displayContextToPerspective(displayContext, bypass);
        if (perspective.equals((Object)CustomItemTransformations.Perspective.GUI)) {
            float scaleGUI;
            if (iso) {
                return 0.7f;
            }
            if (debug && (scaleGUI = DebugUtils.getValue("scaleGUI")) != 0.0f) {
                return scaleGUI;
            }
            scaleGUI = customTransformation.getScale(CustomItemTransformations.Perspective.GUI);
            if (scaleGUI != 0.0f) {
                return scaleGUI;
            }
            return 0.7f;
        }
        if (perspective.equals((Object)CustomItemTransformations.Perspective.FirstPersonHands)) {
            float scaleWorld2;
            if (iso) {
                return 0.5f;
            }
            if (debug && (scaleWorld2 = DebugUtils.getValue("scaleHands")) != 0.0f) {
                return scaleWorld2;
            }
            float scale = customTransformation.getScale(perspective);
            if (scale != 0.0f) {
                return scale;
            }
            return 0.5f;
        }
        if (iso) {
            return 0.5f;
        }
        if (debug && (scaleWorld = DebugUtils.getValue("scaleWorld")) != 0.0f) {
            return scaleWorld;
        }
        float scale = customTransformation.getScale(perspective);
        if (scale != 0.0f) {
            return scale;
        }
        return 0.5f;
    }

    public static boolean renderIso(ItemDisplayContext displayContext) {
        return switch (displayContext) {
            case ItemDisplayContext.THIRD_PERSON_LEFT_HAND, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, ItemDisplayContext.FIRST_PERSON_LEFT_HAND, ItemDisplayContext.FIRST_PERSON_RIGHT_HAND -> ((String)CommonClient.config.labelRenderingModeHands.get()).equalsIgnoreCase("iso");
            case ItemDisplayContext.GUI -> ((String)CommonClient.config.labelRenderingModeGUI.get()).equalsIgnoreCase("iso");
            default -> ((String)CommonClient.config.labelRenderingModeWorld.get()).equalsIgnoreCase("iso");
        };
    }

    private static CustomItemTransformations.Perspective displayContextToPerspective(ItemDisplayContext itemDisplayContext, RenderBypass bypass) {
        if (bypass != null) {
            if (bypass.isGui()) {
                return CustomItemTransformations.Perspective.GUI;
            }
            return CustomItemTransformations.Perspective.World;
        }
        if (itemDisplayContext.firstPerson()) {
            return CustomItemTransformations.Perspective.FirstPersonHands;
        }
        if (itemDisplayContext.equals((Object)ItemDisplayContext.GUI)) {
            return CustomItemTransformations.Perspective.GUI;
        }
        return CustomItemTransformations.Perspective.World;
    }

    public static float getCustomTranslation(Item labelItem, Direction.Axis axis, CustomItemTransformations customItemTransformations, ItemDisplayContext itemDisplayContext, RenderBypass bypass) {
        if (RenderUtils.isDebug(labelItem)) {
            return DebugUtils.getValue(String.format("translationOffset%sValue", axis.toString().toUpperCase()));
        }
        CustomItemTransformations.Perspective perspective = RenderUtils.displayContextToPerspective(itemDisplayContext, bypass);
        return customItemTransformations.getTranslation(axis, perspective, bypass);
    }

    public static float getCustomRotation(Item labelItem, Direction.Axis axis, CustomItemTransformations customItemTransformations, ItemDisplayContext itemDisplayContext, RenderBypass bypass) {
        if (RenderUtils.isDebug(labelItem)) {
            return (float)Math.toRadians(DebugUtils.getValue(String.format("rotationOffset%sValue", axis.toString().toUpperCase())));
        }
        CustomItemTransformations.Perspective perspective = RenderUtils.displayContextToPerspective(itemDisplayContext, bypass);
        return (float)Math.toRadians(customItemTransformations.getRotation(axis, perspective, bypass));
    }

    public static boolean isBlock(Item labelItem, CustomItemTransformations customItemTransformations) {
        if (RenderUtils.isDebug(labelItem) && DebugUtils.getValue("forceTreatAsBlock") == 1.0f) {
            return true;
        }
        if (labelItem instanceof BlockItem) {
            BlockItem bi = (BlockItem)labelItem;
            if (Minecraft.getInstance().level == null) {
                return true;
            }
            if (bi.getBlock().defaultBlockState().isCollisionShapeFullBlock((BlockGetter)Minecraft.getInstance().level, new BlockPos(0, 0, 0))) {
                return true;
            }
            return customItemTransformations.isTreatAsBlock();
        }
        return false;
    }

    public static float getBlockModelZOffset(Item labelItem, CustomItemTransformations customItemTransformations, float scale, ItemDisplayContext displayContext, boolean isBlockItem, boolean iso) {
        BlockItem blockItem;
        block9: {
            block8: {
                if (iso) {
                    return 0.001f;
                }
                if (RenderUtils.isDebug(labelItem) && DebugUtils.getValue("calculateBoundingBoxOffset") == 1.0f) {
                    return 0.0f;
                }
                if (!(labelItem instanceof BlockItem)) break block8;
                blockItem = (BlockItem)labelItem;
                if (isBlockItem && (!RenderUtils.isDebug(labelItem) || DebugUtils.getValue("forceTreatAsBlock") != 0.0f)) break block9;
            }
            return 0.015625f;
        }
        if (!customItemTransformations.shouldCalculateDynamicBlockOffset()) {
            return 0.0f;
        }
        if (Minecraft.getInstance().level == null) {
            return -(1.0f * scale) / 2.0f + 0.03125f;
        }
        VoxelShape shape = blockItem.getBlock().defaultBlockState().getCollisionShape((BlockGetter)Minecraft.getInstance().level, new BlockPos(0, 0, 0));
        float translationZ = 0.0f;
        if (!shape.isEmpty()) {
            AABB boundingBox = shape.bounds();
            translationZ -= (float)(boundingBox.getZsize() * (double)scale) / 2.0f;
            translationZ += 0.03125f;
        }
        return translationZ;
    }

    public static float getInitialTranslation(Direction.Axis axis, Direction blockFacing) {
        if (axis.equals((Object)Direction.Axis.X)) {
            if (EnumSet.of(Direction.NORTH, Direction.EAST).contains(blockFacing)) {
                return -0.5f;
            }
        } else if (axis.equals((Object)Direction.Axis.Y)) {
            if (!EnumSet.of(Direction.UP).contains(blockFacing)) {
                return -0.5f;
            }
        } else if (axis.equals((Object)Direction.Axis.Z)) {
            if (EnumSet.of(Direction.UP, Direction.SOUTH, Direction.EAST).contains(blockFacing)) {
                return 1.0f;
            }
            return 0.0f;
        }
        return 0.5f;
    }

    public static void translateShulkerBoxFlat(boolean flatLarge, PoseStack matrixStack) {
        float scale = 1.59375f * (flatLarge ? 1.0f : 0.8f);
        matrixStack.translate(0.5, 0.5, 0.5);
        matrixStack.scale(scale, scale, scale);
        matrixStack.mulPose((Quaternionfc)Axis.YN.rotationDegrees(45.0f));
        matrixStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(60.0f));
        matrixStack.translate(-0.5, -0.5, -0.5);
    }

    public static void setIsoLighting(boolean gui, boolean flat, PoseStack matrixStack, ItemStackRenderState itemRenderState) {
        boolean sideLit = itemRenderState.usesBlockLight();
        Matrix3f mat = new Matrix3f();
        if (sideLit) {
            mat.rotateXYZ((float)Math.toRadians(-30.0), (float)Math.toRadians(15.0), 0.0f);
            if (gui) {
                mat.rotateXYZ(0.0f, 0.0f, (float)Math.toRadians(-240.0));
            }
        } else if (!gui) {
            mat.rotateXYZ((float)Math.toRadians(-90.0), 0.0f, 0.0f);
        }
        if (gui && !flat) {
            mat.rotateXYZ(0.0f, (float)Math.toRadians(-60.0), 0.0f);
        }
        matrixStack.last().normal().set((Matrix3fc)mat);
    }

    public static void applyCustomTransformations(PoseStack matrixStack, ItemStack label, CustomItemTransformations customTransformations, ItemDisplayContext displayContext, float scale, boolean isBlock, float openness, boolean iso, RenderBypass bypass) {
        matrixStack.translate(RenderUtils.getCustomTranslation(label.getItem(), Direction.Axis.X, customTransformations, displayContext, bypass), RenderUtils.getCustomTranslation(label.getItem(), Direction.Axis.Y, customTransformations, displayContext, bypass), RenderUtils.getCustomTranslation(label.getItem(), Direction.Axis.Z, customTransformations, displayContext, bypass) + RenderUtils.getBlockModelZOffset(label.getItem(), customTransformations, scale, displayContext, isBlock, iso) + openness * 0.5f);
        matrixStack.mulPose((Matrix4fc)new Matrix4f().rotateXYZ(RenderUtils.getCustomRotation(label.getItem(), Direction.Axis.X, customTransformations, displayContext, bypass), RenderUtils.getCustomRotation(label.getItem(), Direction.Axis.Y, customTransformations, displayContext, bypass) + (float)Math.toRadians(180.0), RenderUtils.getCustomRotation(label.getItem(), Direction.Axis.Z, customTransformations, displayContext, bypass)));
    }

    public static void fixLighting(PoseStack matrices, ItemStackRenderState itemRenderState, RenderBypass bypass, boolean gui, boolean flat, boolean iso, CustomItemTransformations customTransformations) {
        if (bypass == null && iso) {
            RenderUtils.setIsoLighting(gui, flat, matrices, itemRenderState);
        }
        if (bypass != null && iso) {
            matrices.last().normal().set((Matrix3fc)new Matrix3f().rotateXYZ((float)Math.toRadians(112.0), (float)Math.toRadians(10.0), (float)Math.toRadians(0.0)));
        }
        if (!iso && (gui || bypass != null)) {
            CustomItemTransformations.Perspective guiPersp = CustomItemTransformations.Perspective.GUI;
            if (!flat) {
                matrices.last().normal().set((Matrix3fc)new Matrix3f().rotateXYZ((float)Math.toRadians(-customTransformations.getRotation(Direction.Axis.X, guiPersp) - 90.0f), (float)Math.toRadians(-customTransformations.getRotation(Direction.Axis.Y, guiPersp) + 90.0f), (float)Math.toRadians(-customTransformations.getRotation(Direction.Axis.Z, guiPersp) + 15.0f)));
            } else {
                matrices.last().normal().set((Matrix3fc)new Matrix3f().rotateXYZ((float)Math.toRadians(-customTransformations.getRotation(Direction.Axis.X, guiPersp) + 90.0f), (float)Math.toRadians(-customTransformations.getRotation(Direction.Axis.Y, guiPersp) + 120.0f), (float)Math.toRadians(-customTransformations.getRotation(Direction.Axis.Z, guiPersp) + 120.0f)));
            }
        }
    }

    public static int getTopHeightOverflow(TrackingItemStackRenderState itemStackRenderState) {
        Item labelItem = RenderUtils.getLabelItemFromModelKey(itemStackRenderState.getModelIdentity());
        if (labelItem == null) {
            return 0;
        }
        if (DebugUtils.isDebugMode() && RenderUtils.isDebug(labelItem)) {
            return (int)DebugUtils.getValue("heightOverflow");
        }
        if (!((String)CommonClient.config.renderFlat.get()).equalsIgnoreCase("disabled")) {
            return 0;
        }
        if (((String)CommonClient.config.labelRenderingModeGUI.get()).equalsIgnoreCase("iso")) {
            return 0;
        }
        ItemStack label = ((IItemStackRenderState)itemStackRenderState).shulker_box_labels$getLabel();
        if (label == null || label.isEmpty()) {
            return 0;
        }
        CustomItemTransformations customTransformations = CustomItemTransformationMap.getItemTransformation(label.getItem());
        if (customTransformations == null) {
            return 0;
        }
        return customTransformations.getTopHeightOverflow();
    }

    @Nullable
    private static Item getLabelItemFromModelKey(Object obj) {
        if (!(obj instanceof ArrayList)) {
            return null;
        }
        ArrayList ar = (ArrayList)obj;
        for (Object o : ar) {
            if (!(o instanceof LabelItemObject)) continue;
            LabelItemObject labelItemObject = (LabelItemObject)o;
            if (labelItemObject.label() == null || labelItemObject.label().isEmpty()) {
                return null;
            }
            return labelItemObject.label().getItem();
        }
        return null;
    }

    public static boolean usesBlockLight(boolean original, Object modelKey) {
        if (((String)CommonClient.config.renderFlat.get()).equalsIgnoreCase("disabled")) {
            return original;
        }
        if (modelKey == null) {
            return original;
        }
        if (!(modelKey instanceof ArrayList)) {
            return original;
        }
        ArrayList arrayList = (ArrayList)modelKey;
        ArrayList ar = arrayList;
        if (ar.isEmpty()) {
            return original;
        }
        if (ar.size() <= 2) {
            return original;
        }
        LabelItemObject labelItemObject = RenderUtils.findLabelItemObjectInModelIdentity(ar);
        if (labelItemObject == null) {
            return original;
        }
        if (((String)CommonClient.config.renderFlat.get()).equalsIgnoreCase("enabled") || ((String)CommonClient.config.renderFlat.get()).equalsIgnoreCase("onlyLabeled") && labelItemObject.label() != null && !labelItemObject.label().isEmpty()) {
            return false;
        }
        return original;
    }

    @Unique
    @Nullable
    private static LabelItemObject findLabelItemObjectInModelIdentity(ArrayList<Object> list) {
        for (Object o : list) {
            if (!(o instanceof LabelItemObject)) continue;
            return (LabelItemObject)o;
        }
        return null;
    }
}

