/*
 * Decompiled with CFR 0.152.
 */
package com.steveh259.shulkerboxlabels.common.utils;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataComponentUtils {
    public static final String LABEL_KEY_OLD = "labeled-shulker-boxes:label";
    public static final String FACING_KEY_OLD = "labeled-shulker-boxes:facing";
    public static final String LABEL_KEY = "shulker-box-labels:label";
    public static final String FACING_KEY = "shulker-box-labels:facing";

    @NotNull
    private static CompoundTag getCustomDataCompound(ItemStack itemStack) {
        CustomData nbtComponent = (CustomData)itemStack.get(DataComponents.CUSTOM_DATA);
        if (nbtComponent != null) {
            return nbtComponent.copyTag();
        }
        return new CompoundTag();
    }

    @NotNull
    private static CompoundTag getCustomDataCompound(BlockEntity be) {
        CustomData nbtComponent = (CustomData)be.components().get(DataComponents.CUSTOM_DATA);
        if (nbtComponent != null) {
            return nbtComponent.copyTag();
        }
        return new CompoundTag();
    }

    @Nullable
    public static ItemStack getLabel(CompoundTag nbtCompound, HolderLookup.Provider wrapperLookup) {
        Tag itemStackTag = nbtCompound.get(LABEL_KEY);
        if (itemStackTag == null) {
            return null;
        }
        return DataComponentUtils.decodeItemStack(itemStackTag.asCompound().orElse(null), wrapperLookup);
    }

    @Nullable
    public static ItemStack getLabelOld(CompoundTag nbtCompound, HolderLookup.Provider wrapperLookup) {
        Tag itemStackTag = nbtCompound.get(LABEL_KEY_OLD);
        if (itemStackTag == null) {
            return null;
        }
        return DataComponentUtils.decodeItemStack(itemStackTag.asCompound().orElse(null), wrapperLookup);
    }

    @Nullable
    public static ItemStack getLabel(BlockEntity be, Level world) {
        if (world == null) {
            return null;
        }
        HolderLookup.Provider lookup = HolderLookup.Provider.create((Stream)world.registryAccess().listRegistries());
        CompoundTag nbtCompound = DataComponentUtils.getCustomDataCompound(be);
        return DataComponentUtils.getLabel(nbtCompound, lookup);
    }

    @Nullable
    public static ItemStack getLabelOld(BlockEntity be, Level world) {
        if (world == null) {
            return null;
        }
        HolderLookup.Provider lookup = HolderLookup.Provider.create((Stream)world.registryAccess().listRegistries());
        CompoundTag nbtCompound = DataComponentUtils.getCustomDataCompound(be);
        return DataComponentUtils.getLabelOld(nbtCompound, lookup);
    }

    @Nullable
    public static ItemStack getLabel(ItemStack itemStack, Level world) {
        if (world == null) {
            return null;
        }
        HolderLookup.Provider lookup = HolderLookup.Provider.create((Stream)world.registryAccess().listRegistries());
        CompoundTag nbtCompound = DataComponentUtils.getCustomDataCompound(itemStack);
        return DataComponentUtils.getLabel(nbtCompound, lookup);
    }

    @Nullable
    public static ItemStack getLabelOld(ItemStack itemStack, Level world) {
        if (world == null) {
            return null;
        }
        HolderLookup.Provider lookup = HolderLookup.Provider.create((Stream)world.registryAccess().listRegistries());
        CompoundTag nbtCompound = DataComponentUtils.getCustomDataCompound(itemStack);
        return DataComponentUtils.getLabelOld(nbtCompound, lookup);
    }

    public static void setLabel(BlockEntity be, ItemStack label, HolderLookup.Provider registries) {
        Tag encoded = DataComponentUtils.encodeItemStack(label, (DynamicOps<Tag>)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registries));
        if (encoded == null) {
            return;
        }
        CompoundTag customDataCompound = DataComponentUtils.getCustomDataCompound(be);
        customDataCompound.put(LABEL_KEY, encoded);
        DataComponentMap map = be.components();
        DataComponentMap.Builder builder = DataComponentMap.builder();
        builder.addAll(map);
        builder.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)customDataCompound));
        be.setComponents(builder.build());
    }

    public static void setLabel(BlockEntity be, ItemStack label) {
        if (be.getLevel() == null) {
            return;
        }
        MinecraftServer server = be.getLevel().getServer();
        if (server == null) {
            return;
        }
        HolderLookup.Provider lookup = HolderLookup.Provider.create((Stream)server.registryAccess().listRegistries());
        Tag encoded = DataComponentUtils.encodeItemStack(label, (DynamicOps<Tag>)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)lookup));
        if (encoded == null) {
            return;
        }
        CompoundTag customDataCompound = DataComponentUtils.getCustomDataCompound(be);
        customDataCompound.put(LABEL_KEY, encoded);
        DataComponentMap map = be.components();
        DataComponentMap.Builder builder = DataComponentMap.builder();
        builder.addAll(map);
        builder.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)customDataCompound));
        be.setComponents(builder.build());
    }

    public static void setLabel(ItemStack itemStack, ItemStack label, MinecraftServer server) {
        if (server == null) {
            return;
        }
        CompoundTag nbtCompound = DataComponentUtils.getCustomDataCompound(itemStack);
        Tag encoded = DataComponentUtils.encodeItemStack(label, server);
        if (encoded == null) {
            return;
        }
        nbtCompound.put(LABEL_KEY, encoded);
        itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbtCompound));
    }

    public static void setLabel(ItemStack itemStack, ItemStack label, Level world) {
        if (world == null) {
            return;
        }
        CompoundTag nbtCompound = DataComponentUtils.getCustomDataCompound(itemStack);
        Tag encoded = DataComponentUtils.encodeItemStack(label, (DynamicOps<Tag>)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)world.registryAccess()));
        if (encoded == null) {
            return;
        }
        nbtCompound.put(LABEL_KEY, encoded);
        itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbtCompound));
    }

    public static void removeLabel(ItemStack itemStack) {
        CompoundTag nbtCompound = DataComponentUtils.getCustomDataCompound(itemStack);
        nbtCompound.remove(LABEL_KEY);
        if (!nbtCompound.isEmpty()) {
            itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbtCompound));
        } else {
            itemStack.remove(DataComponents.CUSTOM_DATA);
        }
    }

    @Nullable
    public static Direction getFacing(CompoundTag nbtCompound) {
        String facingString = nbtCompound.getString(FACING_KEY).orElse(null);
        if (facingString == null || facingString.isEmpty()) {
            return null;
        }
        return Direction.byName((String)facingString);
    }

    @Nullable
    public static Direction getFacingOld(CompoundTag nbtCompound) {
        String facingString = nbtCompound.getString(FACING_KEY_OLD).orElse(null);
        if (facingString == null || facingString.isEmpty()) {
            return null;
        }
        return Direction.byName((String)facingString);
    }

    @Nullable
    public static Direction getFacing(BlockEntity be) {
        CompoundTag nbtCompound = DataComponentUtils.getCustomDataCompound(be);
        return DataComponentUtils.getFacing(nbtCompound);
    }

    @Nullable
    public static Direction getFacingOld(BlockEntity be) {
        CompoundTag nbtCompound = DataComponentUtils.getCustomDataCompound(be);
        return DataComponentUtils.getFacingOld(nbtCompound);
    }

    public static void setFacing(BlockEntity be, Direction facing) {
        CompoundTag customDataCompound = DataComponentUtils.getCustomDataCompound(be);
        customDataCompound.putString(FACING_KEY, facing.toString());
        DataComponentMap map = be.components();
        DataComponentMap.Builder builder = DataComponentMap.builder();
        builder.addAll(map);
        builder.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)customDataCompound));
        be.setComponents(builder.build());
    }

    public static void setFacing(ItemStack itemStack, Direction facing) {
        CompoundTag customDataCompound = DataComponentUtils.getCustomDataCompound(itemStack);
        customDataCompound.putString(FACING_KEY, facing.toString());
        itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)customDataCompound));
    }

    public static void removeFacing(ItemStack itemStack) {
        CompoundTag nbtCompound = DataComponentUtils.getCustomDataCompound(itemStack);
        nbtCompound.remove(FACING_KEY);
        if (!nbtCompound.isEmpty()) {
            itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbtCompound));
        } else {
            itemStack.remove(DataComponents.CUSTOM_DATA);
        }
    }

    public static void removeOldModIdData(ShulkerBoxBlockEntity be) {
        CompoundTag customData = DataComponentUtils.getCustomDataCompound((BlockEntity)be);
        if (customData.isEmpty()) {
            return;
        }
        customData.remove(LABEL_KEY_OLD);
        customData.remove(FACING_KEY_OLD);
        DataComponentMap.Builder builder = DataComponentMap.builder();
        builder.addAll(be.components());
        builder.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)customData));
        be.setComponents(builder.build());
    }

    @Nullable
    public static ItemStack decodeItemStack(@Nullable CompoundTag nbtCompound, HolderLookup.Provider registryLookup) {
        if (nbtCompound == null) {
            return null;
        }
        String customName = nbtCompound.getString(DataComponents.CUSTOM_NAME.toString()).orElse("");
        if (customName.equals("shulker-box-labels$bypassRegularRendering")) {
            ResourceLocation id = ResourceLocation.tryParse((String)nbtCompound.getString("id").orElse(""));
            if (id == null) {
                return ItemStack.EMPTY;
            }
            Holder.Reference item = BuiltInRegistries.ITEM.get(id).orElse(null);
            if (item == null) {
                return ItemStack.EMPTY;
            }
            ItemStack itemStack = new ItemStack((Holder)item);
            CompoundTag nbt = nbtCompound.getCompoundOrEmpty(DataComponents.CUSTOM_DATA.toString());
            itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbt.copy()));
            itemStack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)customName));
            return itemStack;
        }
        RegistryOps ops = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registryLookup);
        Dynamic dynamic = new Dynamic((DynamicOps)ops, (Object)nbtCompound);
        DataResult res = ItemStack.CODEC.decode(dynamic);
        Pair pair = res.result().orElse(null);
        if (pair == null) {
            return null;
        }
        return (ItemStack)pair.getFirst();
    }

    @Nullable
    public static Tag encodeItemStack(ItemStack itemStack, MinecraftServer server) {
        if (server == null) {
            return null;
        }
        HolderLookup.Provider lookup = HolderLookup.Provider.create((Stream)server.registryAccess().listRegistries());
        RegistryOps ops = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)lookup);
        return DataComponentUtils.encodeItemStack(itemStack, (DynamicOps<Tag>)ops);
    }

    @Nullable
    public static Tag encodeItemStack(ItemStack itemStack, DynamicOps<Tag> ops) {
        DataResult result = ItemStack.CODEC.encode((Object)itemStack, ops, (Object)new CompoundTag());
        return result.result().orElse(null);
    }
}

