/*
 * Decompiled with CFR 0.152.
 */
package com.steveh259.shulkerboxlabels.mixin.client;

import com.steveh259.shulkerboxlabels.common.CommonClient;
import com.steveh259.shulkerboxlabels.mixin.client.invokers.UseOnContextInvoker;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockPlaceContext.class})
public abstract class BlockPlaceContextMixin {
    @Shadow
    public abstract Direction[] getNearestLookingDirections();

    @Shadow
    public abstract BlockPos getClickedPos();

    @Inject(method={"<init>(Lnet/minecraft/world/item/context/UseOnContext;)V"}, at={@At(value="TAIL")})
    private void afterInit(UseOnContext useOnContext, CallbackInfo ci) {
        if (!CommonClient.isModInstalledServerSide()) {
            return;
        }
        Item item = useOnContext.getItemInHand().getItem();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockItem bi = (BlockItem)item;
        if (!(bi.getBlock() instanceof ShulkerBoxBlock)) {
            return;
        }
        BlockHitResult blockHitResult = ((UseOnContextInvoker)useOnContext).shulker_box_labels$getBlockHitResult();
        if (!EnumSet.of(Direction.UP, Direction.DOWN).contains(blockHitResult.getDirection())) {
            return;
        }
        BlockPos pos = this.getClickedPos();
        Player player = ((BlockPlaceContext)this).getPlayer();
        Direction lookingDir = null;
        if (player == null) {
            for (Direction dir : this.getNearestLookingDirections()) {
                if (dir == Direction.UP || dir == Direction.DOWN) continue;
                lookingDir = dir;
                break;
            }
            if (lookingDir == null) {
                return;
            }
        } else {
            lookingDir = player.getDirection();
        }
        CommonClient.cache.putOptimisticFacing(pos, lookingDir);
    }
}

