/*
 * Decompiled with CFR 0.152.
 */
package com.steveh259.shulkerboxlabels.mixin.client;

import com.steveh259.shulkerboxlabels.common.CommonClient;
import com.steveh259.shulkerboxlabels.common.ducks.IItemStackRenderState;
import com.steveh259.shulkerboxlabels.common.utils.DataComponentUtils;
import com.steveh259.shulkerboxlabels.common.utils.LabelItemObject;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemModelResolver.class})
public class ItemModelResolverMixin {
    @Inject(method={"updateForTopItem"}, at={@At(value="TAIL")})
    private void afterUpdateForTopItem(ItemStackRenderState itemStackRenderState, ItemStack itemStack, ItemDisplayContext itemDisplayContext, Level level, ItemOwner itemOwner, int i, CallbackInfo ci) {
        BlockItem blockItem;
        if (itemStack == null || itemStack.isEmpty()) {
            return;
        }
        Item item = itemStack.getItem();
        if (!(item instanceof BlockItem) || !((blockItem = (BlockItem)item).getBlock() instanceof ShulkerBoxBlock)) {
            return;
        }
        ItemStack label = null;
        if (Minecraft.getInstance().level == null) {
            Tag labelData;
            CustomData customData = (CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
            if (!customData.isEmpty() && (labelData = customData.copyTag().get("shulker-box-labels:label")) != null) {
                label = DataComponentUtils.decodeItemStack(labelData.asCompound().orElse(null), null);
            }
        } else {
            label = CommonClient.isOldModIdServerSide() ? DataComponentUtils.getLabelOld(itemStack, (Level)Minecraft.getInstance().level) : DataComponentUtils.getLabel(itemStack, (Level)Minecraft.getInstance().level);
        }
        ((IItemStackRenderState)itemStackRenderState).shulker_box_labels$setParent(itemStack);
        ((IItemStackRenderState)itemStackRenderState).shulker_box_labels$setLabel(label);
        byte x = 0;
        if (label != null && !label.isEmpty()) {
            x = (byte)(x | 1);
        }
        if (((String)CommonClient.config.renderFlat.get()).equalsIgnoreCase("enabled") || ((String)CommonClient.config.renderFlat.get()).equalsIgnoreCase("onlyLabeled") && label != null && !label.isEmpty() && ((Boolean)CommonClient.config.renderLabels.get()).booleanValue()) {
            x = (byte)(x | 2);
            if (((Boolean)CommonClient.config.renderFlatLarge.get()).booleanValue()) {
                x = (byte)(x | 4);
            }
        }
        if (((String)CommonClient.config.labelRenderingModeGUI.get()).equalsIgnoreCase("iso")) {
            x = (byte)(x | 8);
        }
        itemStackRenderState.appendModelIdentityElement((Object)new LabelItemObject(itemStack, (ItemStack)((Boolean)CommonClient.config.renderLabels.get() != false ? label : null)));
        itemStackRenderState.appendModelIdentityElement((Object)x);
        if (itemStackRenderState.isAnimated()) {
            return;
        }
        if (label == null) {
            return;
        }
        if (label.isEmpty()) {
            return;
        }
        ItemStackRenderState itemRenderState = new ItemStackRenderState();
        Minecraft.getInstance().getItemModelResolver().updateForTopItem(itemRenderState, label, ItemDisplayContext.GUI, (Level)Minecraft.getInstance().level, null, 0);
        if (itemRenderState.isAnimated()) {
            itemStackRenderState.setAnimated();
        }
    }
}

