/*
 * Decompiled with CFR 0.152.
 */
package com.steveh259.shulkerboxlabels.mixin.client;

import com.steveh259.shulkerboxlabels.common.CommonClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin {
    @Shadow
    @Nullable
    public ClientLevel level;
    @Shadow
    @Nullable
    public Screen screen;
    @Unique
    private long lastChecked = 0L;

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    public void onTick(CallbackInfo ci) {
        this.updateCaches();
    }

    @Unique
    private void updateCaches() {
        if (this.level == null) {
            CommonClient.cache.clearCaches();
            return;
        }
        int cacheWaitDuration = 10000;
        long now = System.currentTimeMillis();
        if (now - this.lastChecked > (long)cacheWaitDuration) {
            CommonClient.cache.removeAllEntriesOlderThan(cacheWaitDuration);
        }
    }
}

