/*
 * Decompiled with CFR 0.152.
 */
package com.steveh259.shulkerboxlabels.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.steveh259.shulkerboxlabels.common.CommonClient;
import com.steveh259.shulkerboxlabels.common.cache.ShulkerBoxBlockEntityEntry;
import com.steveh259.shulkerboxlabels.common.custom_transformations.CustomItemTransformationMap;
import com.steveh259.shulkerboxlabels.common.custom_transformations.CustomItemTransformations;
import com.steveh259.shulkerboxlabels.common.ducks.IShulkerBoxRenderState;
import com.steveh259.shulkerboxlabels.common.ducks.IShulkerBoxRenderer;
import com.steveh259.shulkerboxlabels.common.render.LabelRenderer;
import com.steveh259.shulkerboxlabels.common.render.utils.RenderBypass;
import com.steveh259.shulkerboxlabels.common.render.utils.RenderUtils;
import com.steveh259.shulkerboxlabels.common.utils.DebugUtils;
import java.util.EnumSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.ShulkerBoxRenderer;
import net.minecraft.client.renderer.blockentity.state.ShulkerBoxRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ShulkerBoxRenderer.class})
public class ShulkerBoxRendererMixin
implements IShulkerBoxRenderer {
    @Unique
    private ItemDisplayContext itemDisplayContext;
    @Unique
    private ItemStack parent;
    @Unique
    private ItemStack label;
    @Unique
    private Direction blockFacing = Direction.UP;
    @Unique
    private Direction labelFacing = Direction.NORTH;
    @Unique
    private ShulkerBoxBlockEntity currentShulkerBoxBlockEntity = null;
    @Unique
    private float overriddenOpenness = -1.0f;

    @Inject(method={"extractRenderState(Lnet/minecraft/world/level/block/entity/ShulkerBoxBlockEntity;Lnet/minecraft/client/renderer/blockentity/state/ShulkerBoxRenderState;FLnet/minecraft/world/phys/Vec3;Lnet/minecraft/client/renderer/feature/ModelFeatureRenderer$CrumblingOverlay;)V"}, at={@At(value="HEAD")})
    private void beforeExtractRenderState(ShulkerBoxBlockEntity be, ShulkerBoxRenderState shulkerBoxRenderState, float f, Vec3 vec3, ModelFeatureRenderer.CrumblingOverlay crumblingOverlay, CallbackInfo ci) {
        ((IShulkerBoxRenderState)shulkerBoxRenderState).shulker_box_labels$setBlockEntity(be);
    }

    @Unique
    private void setLocalVariables(@Nullable ShulkerBoxBlockEntityEntry cacheItem, ShulkerBoxBlockEntity be) {
        if (cacheItem == null) {
            this.label = null;
            this.blockFacing = null;
            this.labelFacing = null;
            this.itemDisplayContext = null;
            this.currentShulkerBoxBlockEntity = null;
        } else {
            this.label = cacheItem.label;
            this.blockFacing = cacheItem.blockFacing;
            this.labelFacing = cacheItem.labelFacing;
            this.itemDisplayContext = ItemDisplayContext.FIXED;
            this.currentShulkerBoxBlockEntity = be;
        }
    }

    @Inject(method={"submit(Lnet/minecraft/client/renderer/blockentity/state/ShulkerBoxRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;Lnet/minecraft/client/renderer/state/CameraRenderState;)V"}, at={@At(value="HEAD")})
    private void onFirstSubmit(ShulkerBoxRenderState shulkerBoxRenderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState, CallbackInfo ci) {
        ShulkerBoxBlockEntity be = ((IShulkerBoxRenderState)shulkerBoxRenderState).shulker_box_labels$getBlockEntity();
        ((IShulkerBoxRenderState)shulkerBoxRenderState).shulker_box_labels$setBlockEntity(null);
        ShulkerBoxBlockEntityEntry cacheItem = LabelRenderer.updateBlockEntityCache(be);
        this.setLocalVariables(cacheItem, be);
    }

    @Inject(method={"submit(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;IILnet/minecraft/core/Direction;FLnet/minecraft/client/renderer/feature/ModelFeatureRenderer$CrumblingOverlay;Lnet/minecraft/client/resources/model/Material;I)V"}, at={@At(value="HEAD")})
    public void onSecondRender(PoseStack matrices, SubmitNodeCollector submitNodeCollector, int light, int overlay, Direction direction, float openness, ModelFeatureRenderer.CrumblingOverlay crumblingOverlay, Material material, int k, CallbackInfo ci) {
        ItemStackRenderState itemRenderState;
        float specificScale;
        boolean isBlock;
        CustomItemTransformations customTransformations;
        boolean iso;
        if (this.itemDisplayContext == null) {
            return;
        }
        RenderBypass bypass = RenderBypass.fromLabelItemStack(this.label);
        boolean gui = bypass == null && this.itemDisplayContext.equals((Object)ItemDisplayContext.GUI) || bypass != null && bypass.isGui();
        boolean flat = bypass == null && ((String)CommonClient.config.renderFlat.get()).equalsIgnoreCase("enabled") || bypass == null && ((String)CommonClient.config.renderFlat.get()).equalsIgnoreCase("onlyLabeled") && this.label != null && !this.label.isEmpty() || bypass != null && bypass.isFlat();
        boolean flatLarge = bypass == null && (Boolean)CommonClient.config.renderFlatLarge.get() != false || bypass != null && bypass.isFlatLarge();
        boolean bl = iso = bypass == null && RenderUtils.renderIso(this.itemDisplayContext) || bypass != null && bypass.isIso();
        if (bypass != null) {
            openness = bypass.getRotation();
            this.overriddenOpenness = bypass.getRotation();
        }
        if (gui && flat) {
            RenderUtils.translateShulkerBoxFlat(flatLarge, matrices);
        }
        if (bypass == null && !((Boolean)CommonClient.config.renderLabels.get()).booleanValue()) {
            return;
        }
        if (this.label == null || this.label.isEmpty()) {
            return;
        }
        if (EnumSet.of(Direction.UP, Direction.DOWN).contains(this.blockFacing) && this.labelFacing == null) {
            return;
        }
        ShulkerBoxBlockEntityEntry cacheItem = CommonClient.cache.getShulkerBoxBlockEntityEntry(this.currentShulkerBoxBlockEntity);
        if (DebugUtils.isDebugMode() && (float)BuiltInRegistries.ITEM.getId((Object)this.label.getItem()) == DebugUtils.getValue("itemIndex") || cacheItem == null || cacheItem.customItemTransformations == null || !cacheItem.worldRenderingMode.equalsIgnoreCase((String)CommonClient.config.labelRenderingModeWorld.get())) {
            customTransformations = CustomItemTransformationMap.getItemTransformation(this.label.getItem());
            isBlock = RenderUtils.isBlock(this.label.getItem(), customTransformations);
            specificScale = RenderUtils.getScale(this.itemDisplayContext, this.label.getItem(), bypass);
            if (cacheItem != null) {
                cacheItem.customItemTransformations = customTransformations;
                cacheItem.isBlock = isBlock;
                cacheItem.scale = specificScale;
                if (!cacheItem.worldRenderingMode.equalsIgnoreCase((String)CommonClient.config.labelRenderingModeWorld.get())) {
                    cacheItem.label = null;
                    cacheItem.worldRenderingMode = (String)CommonClient.config.labelRenderingModeWorld.get();
                }
            }
        } else {
            customTransformations = cacheItem.customItemTransformations;
            isBlock = cacheItem.isBlock;
            specificScale = cacheItem.scale;
        }
        float scale = 1.0f;
        if (!iso) {
            scale = isBlock ? 2.0f : 1.0f;
        }
        scale *= specificScale;
        float rotationX = -90.0f;
        float rotationY = 0.0f;
        float rotationZ = 0.0f;
        if (bypass == null && ((Boolean)CommonClient.config.rotateLabel.get()).booleanValue() || bypass != null && bypass.shouldRotateLabel()) {
            rotationZ -= 270.0f * openness;
        }
        if (gui && !flat) {
            rotationZ -= 90.0f;
        }
        if (this.labelFacing != null && EnumSet.of(Direction.UP, Direction.DOWN).contains(this.blockFacing)) {
            rotationZ += (this.labelFacing.toYRot() - 180.0f) * (float)(this.blockFacing == Direction.UP ? -1 : 1);
        }
        matrices.pushPose();
        matrices.mulPose((Matrix4fc)new Matrix4f().rotate((Quaternionfc)this.blockFacing.getRotation()));
        matrices.translate(RenderUtils.getInitialTranslation(Direction.Axis.X, this.blockFacing), RenderUtils.getInitialTranslation(Direction.Axis.Z, this.blockFacing), RenderUtils.getInitialTranslation(Direction.Axis.Y, this.blockFacing));
        matrices.mulPose((Matrix4fc)new Matrix4f().rotateXYZ((float)Math.toRadians(rotationX), (float)Math.toRadians(rotationY), (float)Math.toRadians(rotationZ)));
        if (!iso) {
            RenderUtils.applyCustomTransformations(matrices, this.label, customTransformations, this.itemDisplayContext, specificScale, isBlock, openness, iso, bypass);
        } else {
            matrices.translate(0.0f, 0.0f, 0.008f + openness * 0.5f);
        }
        matrices.scale(scale, scale, iso ? 0.005f : scale);
        if (cacheItem == null || cacheItem.label == null || !ItemStack.matches((ItemStack)cacheItem.label, (ItemStack)this.label)) {
            itemRenderState = new ItemStackRenderState();
            this.forceBypassNestedShulkerBox();
            Minecraft.getInstance().getItemModelResolver().updateForTopItem(itemRenderState, this.label, iso ? ItemDisplayContext.GUI : ItemDisplayContext.FIXED, (Level)Minecraft.getInstance().level, null, 0);
            if (cacheItem != null) {
                cacheItem.label = this.label;
                cacheItem.customItemTransformations = null;
                cacheItem.labelItemRenderState = itemRenderState;
            }
        } else {
            itemRenderState = cacheItem.labelItemRenderState;
        }
        RenderUtils.fixLighting(matrices, itemRenderState, bypass, gui, flat, iso, customTransformations);
        if (!this.isLabelOfNestedShulkerbox(bypass)) {
            this.renderItemStackRenderState(itemRenderState, matrices, light, overlay, submitNodeCollector);
        }
        matrices.popPose();
        this.currentShulkerBoxBlockEntity = null;
        this.parent = null;
        this.label = null;
    }

    @Unique
    private void renderItemStackRenderState(ItemStackRenderState itemStackRenderState, PoseStack poseStack, int light, int overlay, SubmitNodeCollector submitNodeCollector) {
        itemStackRenderState.submit(poseStack, submitNodeCollector, light, overlay, 0);
    }

    @Unique
    private void forceBypassNestedShulkerBox() {
        if (this.label == null || this.label.isEmpty()) {
            return;
        }
        if ((this.parent == null || this.parent.isEmpty()) && this.currentShulkerBoxBlockEntity == null) {
            return;
        }
        Item item = this.label.getItem();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockItem labelBlockItem = (BlockItem)item;
        if (!(labelBlockItem.getBlock() instanceof ShulkerBoxBlock)) {
            return;
        }
        if (this.currentShulkerBoxBlockEntity == null) {
            Item item2 = this.parent.getItem();
            if (!(item2 instanceof BlockItem)) {
                return;
            }
            BlockItem parentBlockItem = (BlockItem)item2;
            if (!(parentBlockItem.getBlock() instanceof ShulkerBoxBlock)) {
                return;
            }
        }
        this.label = new RenderBypass().gui().toItemStack(labelBlockItem.getBlock(), Items.LIGHT);
    }

    @Unique
    private boolean isLabelOfNestedShulkerbox(RenderBypass bypass) {
        return bypass != null && this.label.getItem().equals(Items.LIGHT);
    }

    @ModifyArg(method={"submit(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;IILnet/minecraft/core/Direction;FLnet/minecraft/client/renderer/feature/ModelFeatureRenderer$CrumblingOverlay;Lnet/minecraft/client/resources/model/Material;I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/SubmitNodeCollector;submitModel(Lnet/minecraft/client/model/Model;Ljava/lang/Object;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/RenderType;IIILnet/minecraft/client/renderer/texture/TextureAtlasSprite;ILnet/minecraft/client/renderer/feature/ModelFeatureRenderer$CrumblingOverlay;)V"), index=1)
    private Object overrideOpenness(Object original) {
        if (!(original instanceof Float)) {
            return original;
        }
        Float f = (Float)original;
        return Float.valueOf(this.opennessOverride(f.floatValue()));
    }

    @Unique
    private float opennessOverride(float original) {
        float returnVal = original;
        if (this.overriddenOpenness != -1.0f) {
            returnVal = this.overriddenOpenness;
        }
        this.overriddenOpenness = -1.0f;
        return returnVal;
    }

    @Override
    public void shulker_box_labels$setItemDisplayContext(ItemDisplayContext itemDisplayContext) {
        this.itemDisplayContext = itemDisplayContext;
    }

    @Override
    public void shulker_box_labels$setItemStack(ItemStack itemStack) {
        this.label = itemStack;
    }

    @Override
    public void shulker_box_labels$setParent(ItemStack parent) {
        this.parent = parent;
    }

    @Override
    public ItemStack shulker_box_labels$getParent() {
        return this.parent;
    }
}

