/*
 * Decompiled with CFR 0.152.
 */
package com.steveh259.shulkerboxlabels.mixin.server;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.steveh259.shulkerboxlabels.common.CommonClient;
import com.steveh259.shulkerboxlabels.common.utils.DataComponentUtils;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AnvilMenu.class})
public abstract class AnvilMenuMixin
extends ItemCombinerMenu {
    @Unique
    boolean canTakeOutput = false;
    @Shadow
    private boolean onlyRenaming;
    @Shadow
    @Final
    private DataSlot cost;
    @Shadow
    @Nullable
    private String itemName;

    public AnvilMenuMixin(@Nullable MenuType<?> menuType, int i, Inventory inventory, ContainerLevelAccess containerLevelAccess, ItemCombinerMenuSlotDefinition itemCombinerMenuSlotDefinition) {
        super(menuType, i, inventory, containerLevelAccess, itemCombinerMenuSlotDefinition);
    }

    @Shadow
    @Nullable
    private static String validateName(String string) {
        return null;
    }

    @Inject(method={"createResult"}, at={@At(value="RETURN")})
    private void onCreateResult(CallbackInfo ci) {
        if (this.player.level().isClientSide() && !CommonClient.isModInstalledServerSide()) {
            return;
        }
        ItemStack firstItemStack = this.inputSlots.getItem(0);
        if (firstItemStack.isEmpty() || !this.isShulkerBox(firstItemStack)) {
            return;
        }
        ItemStack secondItemStack = this.inputSlots.getItem(1).copy();
        if (this.isShulkerBox(secondItemStack)) {
            secondItemStack = new ItemStack((ItemLike)secondItemStack.getItem());
        }
        ItemStack outputItemStack = firstItemStack.copy();
        Level world = this.player.level();
        ItemStack oldLabelItemStack = DataComponentUtils.getLabel(firstItemStack, world);
        String oldItemName = firstItemStack.getHoverName().getString();
        String newItemName = AnvilMenuMixin.validateName(this.itemName != null ? this.itemName : "");
        if (newItemName == null) {
            newItemName = "";
        }
        boolean nameChanged = false;
        if (!StringUtil.isBlank((String)newItemName)) {
            if (!newItemName.equals(oldItemName)) {
                outputItemStack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)newItemName));
                nameChanged = true;
            }
        } else if (outputItemStack.has(DataComponents.CUSTOM_NAME)) {
            outputItemStack.remove(DataComponents.CUSTOM_NAME);
            nameChanged = true;
        }
        boolean changed = false;
        boolean block = false;
        if (!secondItemStack.isEmpty()) {
            if (oldLabelItemStack != null && !oldLabelItemStack.isEmpty()) {
                if (!ItemStack.matches((ItemStack)secondItemStack, (ItemStack)oldLabelItemStack)) {
                    DataComponentUtils.setLabel(outputItemStack, secondItemStack, world);
                    changed = true;
                } else {
                    block = true;
                }
            } else {
                DataComponentUtils.setLabel(outputItemStack, secondItemStack, world);
                changed = true;
            }
        } else if (oldLabelItemStack != null && !oldLabelItemStack.isEmpty() && !nameChanged) {
            DataComponentUtils.removeLabel(outputItemStack);
            changed = true;
        }
        if (!block && (nameChanged || changed)) {
            this.cost.set(1);
            this.canTakeOutput = true;
            this.onlyRenaming = true;
            this.resultSlots.setItem(0, outputItemStack);
        } else {
            this.cost.set(0);
            this.canTakeOutput = false;
        }
    }

    @ModifyReturnValue(method={"mayPickup"}, at={@At(value="RETURN")})
    private boolean afterMayPickup(boolean original, Player player, boolean bl) {
        if (!this.canTakeOutput) {
            return original;
        }
        return player.isCreative() || player.experienceLevel >= this.cost.get() && this.cost.get() > 0;
    }

    @Unique
    private boolean isShulkerBox(ItemStack is) {
        BlockItem bi;
        if (is == null || is.isEmpty()) {
            return false;
        }
        Item item = is.getItem();
        return item instanceof BlockItem && (bi = (BlockItem)item).getBlock() instanceof ShulkerBoxBlock;
    }
}

