/*
 * Decompiled with CFR 0.152.
 */
package com.steveh259.shulkerboxlabels.mixin.server;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.mojang.serialization.Codec;
import com.steveh259.shulkerboxlabels.common.utils.DataComponentUtils;
import java.util.EnumSet;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockEntity.class})
public abstract class BlockEntityMixin {
    @Shadow
    public abstract CompoundTag saveWithoutMetadata(HolderLookup.Provider var1);

    @ModifyReturnValue(method={"getUpdateTag"}, at={@At(value="RETURN")})
    private CompoundTag afterGetUpdateTag(CompoundTag original, HolderLookup.Provider provider) {
        if (!((BlockEntity)this instanceof ShulkerBoxBlockEntity)) {
            return original;
        }
        return this.saveWithoutMetadata(provider);
    }

    @ModifyReturnValue(method={"getUpdatePacket"}, at={@At(value="RETURN")})
    private Packet<ClientGamePacketListener> afterGetUpdatePacket(Packet<ClientGamePacketListener> original) {
        if (!((BlockEntity)this instanceof ShulkerBoxBlockEntity)) {
            return original;
        }
        return ClientboundBlockEntityDataPacket.create((BlockEntity)((BlockEntity)this));
    }

    @Inject(method={"loadWithComponents"}, at={@At(value="TAIL")})
    private void afterLoadWithComponents(ValueInput valueInput, CallbackInfo ci) {
        Direction facing;
        BlockEntityMixin blockEntityMixin = this;
        if (!(blockEntityMixin instanceof ShulkerBoxBlockEntity)) {
            return;
        }
        ShulkerBoxBlockEntity be = (ShulkerBoxBlockEntity)blockEntityMixin;
        ValueInput componentsValueInput = valueInput.child("components").orElse(null);
        if (componentsValueInput == null) {
            return;
        }
        ItemStack label = (ItemStack)this.getOldValue(componentsValueInput, "labeled-shulker-boxes:label", ItemStack.STRICT_CODEC);
        if (label != null && !label.isEmpty()) {
            facing = (Direction)this.getOldValue(componentsValueInput, "labeled-shulker-boxes:facing", (Codec)Direction.CODEC);
            DataComponentUtils.removeOldModIdData(be);
        } else {
            Holder legacyItem = (Holder)this.getLegacyValue(componentsValueInput, "labeled-shulker-boxes:label", Item.CODEC);
            if (legacyItem == null) {
                return;
            }
            label = new ItemStack((ItemLike)legacyItem.value());
            if (label == null || label.isEmpty()) {
                return;
            }
            facing = (Direction)this.getLegacyValue(componentsValueInput, "labeled-shulker-boxes:facing", (Codec)Direction.CODEC);
        }
        if (label == null || label.isEmpty()) {
            return;
        }
        DataComponentUtils.setLabel((BlockEntity)be, label);
        BlockState state = be.getBlockState();
        if (state.hasProperty((Property)ShulkerBoxBlock.FACING) && EnumSet.of(Direction.UP, Direction.DOWN).contains(state.getValue((Property)ShulkerBoxBlock.FACING))) {
            if (facing == null) {
                facing = Direction.NORTH;
            }
            DataComponentUtils.setFacing((BlockEntity)be, facing);
        }
    }

    @Unique
    @Nullable
    private <T> T getOldValue(ValueInput componentsValueInput, String key, Codec<T> codec) {
        if (componentsValueInput == null) {
            return null;
        }
        ValueInput customDataValueInput = componentsValueInput.child(DataComponents.CUSTOM_DATA.toString()).orElse(null);
        if (customDataValueInput == null) {
            return null;
        }
        return customDataValueInput.read(key, codec).orElse(null);
    }

    @Unique
    @Nullable
    private <T> T getLegacyValue(ValueInput componentsValueInput, String key, Codec<T> codec) {
        if (componentsValueInput == null) {
            return null;
        }
        return componentsValueInput.read(key, codec).orElse(null);
    }
}

