/*
 * Decompiled with CFR 0.152.
 */
package com.steveh259.shulkerboxlabels.mixin.server;

import com.steveh259.shulkerboxlabels.common.utils.DataComponentUtils;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Block.class})
public class BlockMixin {
    @Inject(method={"setPlacedBy"}, at={@At(value="TAIL")})
    private void afterSetPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack, CallbackInfo ci) {
        if (level.isClientSide()) {
            return;
        }
        if (placer == null) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity == null) {
            return;
        }
        if (!(blockEntity instanceof ShulkerBoxBlockEntity)) {
            return;
        }
        ItemStack label = DataComponentUtils.getLabel(itemStack, level);
        if (label == null) {
            return;
        }
        Direction facing = (Direction)state.getValue((Property)ShulkerBoxBlock.FACING);
        if (!EnumSet.of(Direction.UP, Direction.DOWN).contains(facing)) {
            return;
        }
        DataComponentUtils.setFacing(blockEntity, placer.getDirection());
    }
}

