/*
 * Decompiled with CFR 0.152.
 */
package com.steveh259.shulkerboxlabels.mixin.server;

import com.steveh259.shulkerboxlabels.common.utils.DataComponentUtils;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DirectionalPlaceContext.class})
public abstract class DirectionPlaceContextMixin {
    @Shadow
    public abstract boolean canPlace();

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void afterConstructor(Level level, BlockPos blockPos, Direction dispenserFacing, ItemStack itemStack, Direction blockFacing, CallbackInfo ci) {
        BlockItem blockItem;
        Item item;
        if (!this.canPlace()) {
            return;
        }
        if (itemStack == null || itemStack.isEmpty() || !((item = itemStack.getItem()) instanceof BlockItem) || !((blockItem = (BlockItem)item).getBlock() instanceof ShulkerBoxBlock)) {
            return;
        }
        if (!EnumSet.of(Direction.UP, Direction.DOWN).contains(blockFacing)) {
            return;
        }
        Direction appliedFacing = EnumSet.of(Direction.UP, Direction.DOWN).contains(dispenserFacing) ? Direction.NORTH : dispenserFacing;
        DataComponentUtils.setFacing(itemStack, appliedFacing);
    }
}

