/*
 * Decompiled with CFR 0.152.
 */
package com.steveh259.shulkerboxlabels.mixin.server;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.steveh259.shulkerboxlabels.common.Common;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets={"com.mojang.serialization.MapCodec$RecursiveMapCodec"}, remap=false)
public class RecursiveMapCodecMixin<A, T> {
    @Shadow
    @Final
    private String name;

    @Inject(method={"decode"}, at={@At(value="HEAD")})
    private void beforeDecode(DynamicOps<T> ops, MapLike<T> input, CallbackInfoReturnable<DataResult<A>> cir) {
        if (!this.name.equals("ItemStack")) {
            return;
        }
        Object object = input.get("components");
        if (!(object instanceof CompoundTag)) {
            return;
        }
        CompoundTag componentsCompound = (CompoundTag)object;
        ItemStack label = this.getOldLabel(componentsCompound);
        if (label == null || label.isEmpty()) {
            label = this.getLegacyLabel(componentsCompound);
        }
        if (label == null || label.isEmpty()) {
            return;
        }
        Common.convertibleItemStack = label;
    }

    @Unique
    @Nullable
    private ItemStack getOldLabel(CompoundTag componentsCompound) {
        if (componentsCompound == null) {
            return null;
        }
        CompoundTag customDataCompound = componentsCompound.getCompound(DataComponents.CUSTOM_DATA.toString()).orElse(null);
        if (customDataCompound == null) {
            return null;
        }
        return customDataCompound.read("labeled-shulker-boxes:label", ItemStack.STRICT_CODEC).orElse(null);
    }

    @Unique
    @Nullable
    private ItemStack getLegacyLabel(CompoundTag componentsCompound) {
        if (componentsCompound == null) {
            return null;
        }
        Holder item = componentsCompound.read("labeled-shulker-boxes:label", Item.CODEC).orElse(null);
        if (item == null || ((Item)item.value()).equals(Items.AIR)) {
            return null;
        }
        return new ItemStack((ItemLike)item.value());
    }
}

