/*
 * Decompiled with CFR 0.152.
 */
package com.steveh259.shulkerboxlabels.mixin.server;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.steveh259.shulkerboxlabels.common.utils.DataComponentUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={ShulkerBoxBlock.class})
public class ShulkerBoxBlockMixin {
    @ModifyReturnValue(method={"getDrops"}, at={@At(value="RETURN")})
    private List<ItemStack> onGetDrops(List<ItemStack> original, BlockState blockState, LootParams.Builder builder) {
        BlockEntity brokenBlockEntity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (brokenBlockEntity == null) {
            return original;
        }
        if (!(brokenBlockEntity instanceof ShulkerBoxBlockEntity)) {
            return original;
        }
        ItemStack label = DataComponentUtils.getLabel(brokenBlockEntity, (Level)builder.getLevel());
        if (label == null) {
            return original;
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>(original);
        for (ItemStack itemStack : drops) {
            BlockItem blockItem;
            Item item = itemStack.getItem();
            if (!(item instanceof BlockItem) || !((blockItem = (BlockItem)item).getBlock() instanceof ShulkerBoxBlock)) continue;
            DataComponentUtils.setLabel(itemStack, label, builder.getLevel().getServer());
        }
        return original;
    }
}

