/*
 * Decompiled with CFR 0.152.
 */
package com.steveh259.shulkerboxlabels.neoforge;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.steveh259.shulkerboxlabels.common.Common;
import com.steveh259.shulkerboxlabels.common.CommonClient;
import com.steveh259.shulkerboxlabels.common.config.ConfigScreen;
import com.steveh259.shulkerboxlabels.common.networking.ModInstalledS2CPayload;
import com.steveh259.shulkerboxlabels.common.networking.ModVersionS2CPayload;
import com.steveh259.shulkerboxlabels.common.networking.ShulkerBoxMenuIconS2CPayload;
import com.steveh259.shulkerboxlabels.common.render.pip.CustomPiPRenderState;
import com.steveh259.shulkerboxlabels.common.render.pip.CustomPiPRenderer;
import com.steveh259.shulkerboxlabels.common.utils.VersionUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.Commands;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.RegisterPictureInPictureRenderersEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@Mod(value="shulker_box_labels")
@EventBusSubscriber
public class NeoforgeEntrypoint {
    public NeoforgeEntrypoint() {
        Common.init();
    }

    @SubscribeEvent
    public static void registerPip(RegisterPictureInPictureRenderersEvent event) {
        event.register(CustomPiPRenderState.class, CustomPiPRenderer::new);
    }

    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.optional().playToClient(ModInstalledS2CPayload.TYPE, ModInstalledS2CPayload.CODEC, (payload, ctx) -> CommonClient.setServerSideModVersion(new int[]{0, 0, 0}));
        registrar.optional().playToClient(ModVersionS2CPayload.TYPE, ModVersionS2CPayload.CODEC, (payload, ctx) -> CommonClient.setServerSideModVersion(payload.version()));
        registrar.optional().playToClient(ShulkerBoxMenuIconS2CPayload.TYPE, ShulkerBoxMenuIconS2CPayload.CODEC, (payload, ctx) -> CommonClient.cache.putContainerIcon(payload.containerId(), payload.label()));
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (!player2.connection.hasChannel(ModVersionS2CPayload.TYPE)) {
            return;
        }
        PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new ModVersionS2CPayload(VersionUtils.getSemVer()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @EventBusSubscriber(modid="shulker_box_labels", value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void register(RegisterClientCommandsEvent event) {
            event.getDispatcher().register((LiteralArgumentBuilder)Commands.literal((String)"shulker-box-labels").then(Commands.literal((String)"config").executes(stack -> {
                Minecraft client = Minecraft.getInstance();
                client.schedule(() -> client.setScreen((Screen)new ConfigScreen(client.screen)));
                return 1;
            })));
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(ClientPlayerNetworkEvent.LoggingIn event) {
            CommonClient.setServerSideModVersion(new int[]{-1, -1, -1});
        }
    }
}

