/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.splashfox.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.lx862.splashfox.SplashFox;
import com.lx862.splashfox.data.ImagePosition;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;

public class Config {
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("splashfox");
    public static final Path CUSTOM_IMG_PATH = CONFIG_PATH.resolve("custom_images");
    public static boolean needUpdateTexture = true;
    public double dropHeight = 1.5;
    public double foxSize = 1.5;
    public double speed = 1.0;
    public boolean flipped = false;
    public boolean wobbly = true;
    public String imagePath = "splashfox:textures/gui/blobfox.png";
    public String customPath = null;
    public ImagePosition position = ImagePosition.ABOVE_MOJANG;

    public static Config readConfig() {
        CUSTOM_IMG_PATH.toFile().mkdirs();
        Path configFile = CONFIG_PATH.resolve("config.json");
        if (Files.exists(configFile, new LinkOption[0])) {
            needUpdateTexture = true;
            SplashFox.LOGGER.info("[SplashFox] Reading Config...");
            try {
                return (Config)new Gson().fromJson(Files.readString(configFile), Config.class);
            }
            catch (Exception e) {
                SplashFox.LOGGER.error("Failed to read config!", (Throwable)e);
            }
        } else {
            SplashFox.LOGGER.info("[SplashFox] Config not found, generating one...");
            Config.writeConfig(new Config());
        }
        return new Config();
    }

    public boolean usesCustomImage() {
        return this.customPath != null;
    }

    public class_2960 getBuiltinImageId() {
        return class_2960.method_60654((String)this.imagePath);
    }

    public class_2960 getImageId() {
        return this.usesCustomImage() ? this.getCustomImageId(this.customPath) : this.getBuiltinImageId();
    }

    public class_2960 getCustomImageId(String customPath) {
        return class_2960.method_60655((String)"splashfox", (String)("custom_img_" + customPath));
    }

    public static void writeConfig(Config instance) {
        Gson gson = new Gson();
        JsonElement element = gson.toJsonTree((Object)instance);
        try {
            CONFIG_PATH.toFile().mkdirs();
            Files.write(CONFIG_PATH.resolve("config.json"), Collections.singleton(new GsonBuilder().setPrettyPrinting().create().toJson(element)), new OpenOption[0]);
        }
        catch (Exception e) {
            SplashFox.LOGGER.error("Failed to write config!", (Throwable)e);
        }
    }
}

