/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.splashfox.mixin;

import com.lx862.splashfox.SplashFox;
import com.lx862.splashfox.config.Config;
import com.lx862.splashfox.data.BuiltinResourceTexture;
import com.lx862.splashfox.data.FileSystemResourceTexture;
import com.lx862.splashfox.render.FoxRenderer;
import net.minecraft.class_10537;
import net.minecraft.class_1060;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_425;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_425.class})
public class LoadingOverlayMixin {
    @Unique
    private static final class_2960 EMPTY_LOGO = class_2960.method_60655((String)"splashfox", (String)"textures/empty.png");
    @Shadow
    @Final
    private boolean field_18219;
    @Shadow
    @Final
    private class_310 field_18217;
    @Shadow
    @Final
    public static class_2960 field_2483;
    @Shadow
    private long field_17771;
    @Shadow
    private long field_18220;
    @Unique
    private double elapsed;
    @Unique
    private FoxRenderer renderer;

    @Inject(at={@At(value="HEAD")}, method={"registerTextures"}, cancellable=true)
    private static void splashfox$registerTextures(class_1060 textureManager, CallbackInfo ci) {
        class_2960 imageId = SplashFox.config.getImageId();
        if (SplashFox.config.usesCustomImage()) {
            textureManager.method_65876(imageId, (class_10537)new FileSystemResourceTexture(SplashFox.config.customPath, imageId));
        } else {
            textureManager.method_65876(imageId, (class_10537)new BuiltinResourceTexture(imageId));
        }
        if (SplashFox.config.position.mojangLogoHidden) {
            textureManager.method_65876(field_2483, (class_10537)new BuiltinResourceTexture(EMPTY_LOGO));
            ci.cancel();
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"render"})
    private void splashfox$render(class_332 guiGraphics, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        this.splashfox$ensureTextureRegistered();
        if (this.renderer == null) {
            this.renderer = new FoxRenderer();
        }
        this.elapsed += (double)delta;
        this.renderer.render(this.field_18217, guiGraphics, SplashFox.config.position, SplashFox.config, mouseX, mouseY, this.elapsed, this.splashfox$getOverlayAlpha());
    }

    @Unique
    private void splashfox$ensureTextureRegistered() {
        if (Config.needUpdateTexture) {
            class_425.method_18819((class_1060)this.field_18217.method_1531());
            Config.needUpdateTexture = false;
        }
    }

    @Unique
    private float splashfox$getOverlayAlpha() {
        float g;
        long timeNow = class_156.method_658();
        float f = this.field_17771 > -1L ? (float)(timeNow - this.field_17771) / 1000.0f : -1.0f;
        float f2 = g = this.field_18220 > -1L ? (float)(timeNow - this.field_18220) / 500.0f : -1.0f;
        if (f >= 1.0f) {
            return 1.0f - class_3532.method_15363((float)(f - 1.0f), (float)0.0f, (float)1.0f);
        }
        if (this.field_18219) {
            return class_3532.method_15363((float)g, (float)0.0f, (float)1.0f);
        }
        return 1.0f;
    }
}

