/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.splashfox.render;

import com.lx862.splashfox.config.Config;
import com.lx862.splashfox.data.ImagePosition;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import net.minecraft.class_10799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_9848;
import org.joml.Matrix3x2fStack;

public class FoxRenderer {
    private static final RenderPipeline GUI_NO_CULL = class_10799.method_67887((RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56864}).withLocation("pipeline/gui_textured").withCull(false).build());
    private double shiftY = 0.0;
    private double animationProgress = 0.0;

    public void render(class_310 minecraft, class_332 guiGraphics, ImagePosition imagePosition, Config config, int mouseX, int mouseY, double elapsed, float alpha) {
        double x;
        class_2960 foxImage = config.getImageId();
        Matrix3x2fStack matrices = guiGraphics.method_51448();
        double scaleBasis = Math.min((double)minecraft.method_22683().method_4486() * 0.75, (double)minecraft.method_22683().method_4502()) * 0.25;
        int splashScreenScale = (int)(scaleBasis * 0.5);
        float size = (float)config.foxSize * (float)splashScreenScale;
        double dropHeight = config.dropHeight * (double)splashScreenScale;
        double speedFactor = config.speed;
        boolean wobbly = config.wobbly;
        boolean flipped = config.flipped;
        double centeredScreenWidth = (double)minecraft.method_22683().method_4486() / 2.0 - (double)(size / 2.0f);
        double centeredScreenHeight = (double)minecraft.method_22683().method_4502() / 2.0 - dropHeight;
        double y = switch (imagePosition) {
            case ImagePosition.LEFT_TO_MOJANG -> {
                x = centeredScreenWidth - (double)(6 * splashScreenScale);
                yield centeredScreenHeight + this.shiftY;
            }
            case ImagePosition.RIGHT_TO_MOJANG -> {
                x = centeredScreenWidth + (double)(6 * splashScreenScale);
                yield centeredScreenHeight + this.shiftY;
            }
            case ImagePosition.ABOVE_MOJANG -> {
                x = centeredScreenWidth;
                yield centeredScreenHeight - (double)splashScreenScale - (double)size + this.shiftY;
            }
            case ImagePosition.REPLACE_MOJANG -> {
                x = centeredScreenWidth;
                yield centeredScreenHeight + this.shiftY;
            }
            case ImagePosition.FOLLOW_MOUSE -> {
                x = mouseX;
                yield (double)mouseY + this.shiftY;
            }
            case ImagePosition.GUI_PREVIEW -> {
                x = minecraft.method_22683().method_4502() > 450 ? centeredScreenWidth : (double)(flipped ? 0.0f : (float)minecraft.method_22683().method_4486() - size);
                yield centeredScreenHeight + this.shiftY;
            }
            default -> {
                x = centeredScreenWidth;
                yield this.shiftY;
            }
        };
        matrices.pushMatrix();
        matrices.translate((float)x, (float)y);
        if (flipped) {
            matrices.scale(-1.0f, 1.0f);
            matrices.translate(-size, 0.0f);
        }
        if (wobbly && this.animationProgress <= 0.0) {
            float deformScale = (float)(this.animationProgress * (config.dropHeight * 0.75));
            matrices.translate(size / 2.0f, size);
            matrices.scale(1.0f - deformScale, 1.0f + deformScale);
            matrices.translate(-(size / 2.0f), -size);
        }
        guiGraphics.method_25291(GUI_NO_CULL, foxImage, 0, 0, 0.0f, 0.0f, (int)size, (int)size, (int)size, (int)size, class_9848.method_71346((float)alpha, (int)-1));
        matrices.popMatrix();
        this.animationProgress = this.getBounceProgress(speedFactor, elapsed / 10.0, wobbly);
        this.shiftY = dropHeight * Math.min(0.0, -this.animationProgress) + dropHeight;
    }

    private double getBounceProgress(double speedFactor, double x, boolean wobbly) {
        if (wobbly) {
            return Math.abs(Math.sin(x * speedFactor) * 1.2) - 0.2;
        }
        return Math.abs(Math.sin(x * speedFactor));
    }
}

