/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.splashfox.screen;

import com.lx862.splashfox.SplashFox;
import com.lx862.splashfox.config.Config;
import com.lx862.splashfox.data.FileSystemResourceTexture;
import com.lx862.splashfox.screen.widget.ChooseButton;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1044;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import org.apache.commons.io.FilenameUtils;

public class ChooseImageWidget
extends class_339 {
    private static final int SCROLL_MULTIPLIER = 8;
    private static final int BUTTON_Y_MARGIN = 20;
    private static final int BUTTON_SIZE = 40;
    private final List<ChooseButton> subWidgets;
    private final Consumer<class_4185> addDrawableChild;
    private final String initialSelection;
    private final Config sessionInstance;
    private final class_327 font;
    private double scrolledOffset = 0.0;
    private int totalHeight = 0;
    private int customImageSeparatorY;

    public ChooseImageWidget(Consumer<class_4185> addSelectableChild, String initialSelection, Config sessionInstance) {
        super(50, 50, 50, 50, (class_2561)class_2561.method_43470((String)""));
        this.initialSelection = initialSelection;
        this.addDrawableChild = addSelectableChild;
        this.sessionInstance = sessionInstance;
        this.font = class_310.method_1551().field_1772;
        this.subWidgets = new ArrayList<ChooseButton>();
    }

    public void init() {
        int nextX;
        ArrayList builtInImages = new ArrayList();
        ArrayList customImages = new ArrayList();
        try {
            Path builtInPath = Path.of(SplashFox.class.getResource("/assets/splashfox/textures/gui/").toURI());
            Path customPath = Config.CUSTOM_IMG_PATH;
            Files.list(builtInPath).forEach(filePath -> builtInImages.add(this.addImageButton((Path)filePath, false)));
            Files.list(customPath).forEach(filePath -> customImages.add(this.addImageButton((Path)filePath, true)));
        }
        catch (Exception e) {
            SplashFox.LOGGER.error("", (Throwable)e);
        }
        this.subWidgets.clear();
        this.subWidgets.addAll(builtInImages);
        this.subWidgets.addAll(customImages);
        double widgetWidth = this.method_25368();
        int startX = this.method_46426();
        int startY = this.method_46427();
        int x = 4;
        int y = 4;
        for (ChooseButton button : builtInImages) {
            nextX = x + button.method_25368();
            if ((double)nextX > widgetWidth) {
                x = 4;
                y += button.method_25364() + 20;
            }
            button.method_46421(startX + x);
            button.method_46419(startY + y);
            x += button.method_25368() + 20;
            this.addDrawableChild.accept(button);
        }
        x = 4;
        this.customImageSeparatorY = y += 50;
        y += 20;
        for (ChooseButton button : customImages) {
            nextX = x + button.method_25368();
            if ((double)nextX > widgetWidth) {
                x = this.method_46426();
                y += button.method_25364() + 20;
            }
            button.method_46421(startX + x);
            button.method_46419(startY + y);
            x += button.method_25368() + 20;
            this.addDrawableChild.accept(button);
        }
        this.totalHeight = y + 40;
        this.scrollRelative(0.0);
    }

    public ChooseButton addImageButton(Path filePath, boolean custom) {
        class_2960 location;
        String fileName = filePath.getFileName().toString();
        String fileNameNoExtension = FilenameUtils.removeExtension((String)fileName);
        class_2960 class_29602 = location = custom ? this.sessionInstance.getCustomImageId(fileName) : class_2960.method_60655((String)"splashfox", (String)("textures/gui/" + fileName));
        if (custom) {
            class_310.method_1551().method_1531().method_4616(location, (class_1044)new FileSystemResourceTexture(fileName, location));
        }
        ChooseButton chooseButton = new ChooseButton(0, 0, 40, 40, this.initialSelection.equals(custom ? fileName : location.toString()), location, e -> {
            this.sessionInstance.imagePath = custom ? null : location.toString();
            this.sessionInstance.customPath = custom ? fileName : null;
            for (ChooseButton btn : this.subWidgets) {
                btn.setSelected(false);
            }
            ((ChooseButton)e).setSelected(true);
        }, (class_2561)class_2561.method_43470((String)fileNameNoExtension));
        chooseButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)(custom ? "Custom: " + fileNameNoExtension : fileNameNoExtension))));
        return chooseButton;
    }

    private void positionButtonOffset(double offset) {
        for (ChooseButton button : this.subWidgets) {
            button.setYOffset((int)(-offset));
        }
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.method_44379(this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364());
        for (class_4185 class_41852 : this.subWidgets) {
            boolean buttonInVisibleArea = mouseY >= 30 && mouseY <= class_310.method_1551().method_22683().method_4502() - 40;
            class_41852.method_25394(guiGraphics, mouseX, mouseY, delta);
            class_41852.field_22763 = buttonInVisibleArea;
        }
        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().translate((float)this.method_46426(), (float)((double)this.method_46427() - this.scrolledOffset));
        class_5250 customImageText = class_2561.method_43471((String)"splashfox.gui.custom_img");
        guiGraphics.method_27535(this.font, (class_2561)customImageText, 0, this.customImageSeparatorY, -1);
        int n = this.font.method_27525((class_5348)customImageText) + 4;
        Objects.requireNonNull(this.font);
        int n2 = this.customImageSeparatorY + 9 / 2;
        int n3 = this.method_25368();
        Objects.requireNonNull(this.font);
        guiGraphics.method_25294(n, n2, n3, this.customImageSeparatorY + 9 / 2 + 1, -5592406);
        guiGraphics.method_51448().popMatrix();
        guiGraphics.method_44380();
    }

    protected void method_47399(class_6382 builder) {
    }

    public boolean method_25404(class_11908 keyInput) {
        boolean bl = super.method_25404(keyInput);
        for (ChooseButton chooseButton : this.subWidgets) {
            if (!chooseButton.method_25367()) continue;
            int highestY = chooseButton.method_46427() - 4;
            int lowestY = chooseButton.method_46427() + chooseButton.method_25364() + 4;
            if ((double)lowestY > (double)this.field_22759 + this.scrolledOffset) {
                this.setScrollOffset((double)lowestY - ((double)this.field_22759 - this.scrolledOffset));
            }
            if (highestY >= 0) continue;
            this.scrollRelative(-highestY);
        }
        return bl;
    }

    public void scrollRelative(double amount) {
        this.setScrollOffset(Math.min(this.scrolledOffset - amount * 8.0, (double)(this.totalHeight - this.field_22759)));
    }

    private void setScrollOffset(double scrollOffset) {
        this.scrolledOffset = Math.max(0.0, scrollOffset);
        this.positionButtonOffset(this.scrolledOffset);
    }
}

