/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.minecraft.security;

import java.net.MalformedURLException;
import java.security.Permission;
import live.lingting.minecraft.security.domain.NetworkControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixinSecurityManager
extends SecurityManager {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SecurityManager current;
    private final NetworkControl network;

    @Override
    public void checkPermission(Permission perm) {
        if (this.current != null) {
            this.current.checkPermission(perm);
        }
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
        if (this.current != null) {
            this.current.checkPermission(perm, context);
        }
    }

    @Override
    public void checkConnect(String host, int port) {
        this.checkNetwork(host, port);
        super.checkConnect(host, port);
    }

    @Override
    public void checkConnect(String host, int port, Object context) {
        this.checkNetwork(host, port);
        super.checkConnect(host, port, context);
    }

    void checkNetwork(String host, int port) {
        if (this.network.isReject(host)) {
            this.log.debug("reject access to {}:{}", (Object)host, (Object)port);
            throw new MalformedURLException("Deny access to " + host + ":" + port);
        }
    }

    public MixinSecurityManager(SecurityManager current, NetworkControl network) {
        this.current = current;
        this.network = network;
    }
}

