/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.minecraft.security.launcher;

import java.nio.file.Path;
import live.lingting.minecraft.security.MixinSecurityManager;
import live.lingting.minecraft.security.domain.NetworkControl;
import live.lingting.minecraft.security.enums.LaunchType;
import live.lingting.minecraft.security.properties.ModProperties;
import live.lingting.minecraft.security.properties.NetworkProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultLauncher {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public void init(Path path, String version, LaunchType type) {
        ModProperties properties = ModProperties.loadByGamePath(path);
        try {
            NetworkProperties network = properties.getNetwork();
            NetworkControl control = network.control();
            SecurityManager current = System.getSecurityManager();
            MixinSecurityManager mixin = new MixinSecurityManager(current, control);
            System.setSecurityManager(mixin);
        }
        catch (Exception e) {
            this.log.error("Failed to set security manager", (Throwable)e);
        }
    }
}

