/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.minecraft.security.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import live.lingting.minecraft.security.properties.NetworkProperties;
import live.lingting.minecraft.security.util.JsonUtils;

public class ModProperties {
    public static final String id = "lingting.minecraft.security";
    public static final String name = "LingtingMinecraftSecurity";
    private NetworkProperties network;

    public static ModProperties defaultProperties() {
        ModProperties properties = new ModProperties();
        properties.network = NetworkProperties.defaultProperties();
        return properties;
    }

    public static ModProperties loadByGamePath(Path gamePath) throws IOException {
        Throwable throwable;
        Path configDir = gamePath.resolve("config").resolve("lingting");
        if (!configDir.toFile().exists()) {
            configDir.toFile().mkdirs();
        }
        Path configFile = configDir.resolve("lingting.minecraft.security.json");
        File file = configFile.toFile();
        ModProperties defaulted = ModProperties.defaultProperties();
        if (!file.exists()) {
            file.createNewFile();
        } else {
            try {
                throwable = null;
                try (FileInputStream stream = new FileInputStream(file);){
                    ModProperties config = JsonUtils.toObj(stream, ModProperties.class);
                    defaulted.merge(config);
                }
                catch (Throwable config) {
                    throwable = config;
                    throw config;
                }
            }
            catch (Exception stream) {
                // empty catch block
            }
        }
        throwable = null;
        try (FileWriter writer = new FileWriter(file);){
            String json = JsonUtils.toJson(defaulted);
            writer.write(json);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return defaulted;
    }

    void merge(ModProperties other) {
        if (other == null) {
            return;
        }
        this.network.merge(other.network);
    }

    public NetworkProperties getNetwork() {
        return this.network;
    }

    public void setNetwork(NetworkProperties network) {
        this.network = network;
    }
}

