/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.minecraft.security.properties;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import live.lingting.minecraft.security.domain.NetworkControl;

public class NetworkProperties {
    private Set<String> white;
    private Set<String> black;
    private Boolean allowIp = true;

    public static NetworkProperties defaultProperties() {
        NetworkProperties properties = new NetworkProperties();
        properties.white = new HashSet<String>();
        properties.white.add("minecraft.net");
        properties.white.add("mojang.com");
        properties.white.add("skin.prinzeugen.net");
        properties.white.add("api.mcmod.cn");
        properties.white.add("downloader.meitangdehulu.com");
        properties.white.add("plushie.moe");
        properties.white.add("login.live.com");
        properties.white.add("localhost");
        properties.white.add("xboxlive.com");
        properties.white.add("minecraftservices.com");
        properties.black = Collections.emptySet();
        properties.allowIp = true;
        return properties;
    }

    void merge(NetworkProperties other) {
        if (other == null) {
            return;
        }
        if (other.white != null) {
            this.white = other.white;
        }
        if (other.black != null) {
            this.black = other.black;
        }
        if (other.allowIp != null) {
            this.allowIp = other.allowIp;
        }
    }

    public NetworkControl control() {
        return new NetworkControl(this);
    }

    public Set<String> getWhite() {
        return this.white;
    }

    public Set<String> getBlack() {
        return this.black;
    }

    public Boolean getAllowIp() {
        return this.allowIp;
    }

    public void setWhite(Set<String> white) {
        this.white = white;
    }

    public void setBlack(Set<String> black) {
        this.black = black;
    }

    public void setAllowIp(Boolean allowIp) {
        this.allowIp = allowIp;
    }
}

