/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.minecraft.security;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public class Reflection {
    public static <T> T get(String name, String field) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        return Reflection.get(Class.forName(name), field);
    }

    public static <T> T get(Class<?> cls, String fieldName) throws IllegalAccessException, InvocationTargetException {
        return Reflection.get(null, cls, fieldName);
    }

    public static <T> T get(Object target, String fieldName) throws IllegalAccessException, InvocationTargetException {
        return Reflection.get(target, target.getClass(), fieldName);
    }

    public static <T> T get(Object target, Class<?> cls, String fieldName) throws IllegalAccessException, InvocationTargetException {
        Field field = Reflection.field(cls, fieldName);
        Method method = Reflection.method(cls, "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1));
        if (field != null && field.isAccessible()) {
            return (T)field.get(target);
        }
        if (method != null && method.isAccessible()) {
            return (T)method.invoke(target, new Object[0]);
        }
        if (field != null) {
            field.setAccessible(true);
            return (T)field.get(target);
        }
        if (method != null) {
            method.setAccessible(true);
            return (T)method.invoke(target, new Object[0]);
        }
        return null;
    }

    public static Field field(Class<?> cls, String field) {
        return Reflection.deepMatchArray(cls, Class::getDeclaredFields).stream().filter(it -> Objects.equals(it.getName(), field)).findAny().orElse(null);
    }

    public static <T> T method(Object obj, String methodName) throws InvocationTargetException, IllegalAccessException {
        Method method = Reflection.method(obj.getClass(), methodName);
        if (method == null) {
            return null;
        }
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        return (T)method.invoke(obj, new Object[0]);
    }

    public static Method method(Class<?> cls, String method) {
        return Reflection.deepMatchArray(cls, Class::getDeclaredMethods).stream().filter(it -> Objects.equals(it.getName(), method) && it.getParameterCount() == 0).findAny().orElse(null);
    }

    static <T> List<T> deepMatchArray(Class<?> cls, Function<Class<?>, T[]> function) {
        return Reflection.deepMatch(cls, c -> {
            Object[] ts = (Object[])function.apply((Class<?>)c);
            return Arrays.asList(ts);
        });
    }

    static <T> List<T> deepMatch(Class<?> cls, Function<Class<?>, Collection<T>> function) {
        ArrayList list = new ArrayList();
        Reflection.deep(cls, c -> list.addAll((Collection)function.apply((Class<?>)c)));
        return list;
    }

    static void deep(Class<?> cls, Consumer<Class<?>> consumer) {
        if (cls == null || cls.isAssignableFrom(Object.class)) {
            return;
        }
        consumer.accept(cls);
        Reflection.deep(cls.getSuperclass(), consumer);
    }
}

