/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.minecraft.security.domain;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import live.lingting.minecraft.security.properties.NetworkProperties;

public class NetworkControl {
    static final Map<String, Boolean> CACHE = new ConcurrentHashMap<String, Boolean>();
    private static final Pattern IPV4_PATTERN = Pattern.compile("^((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$");
    private static final Pattern IPV6_PATTERN = Pattern.compile("^(?:[A-Fa-f0-9]{1,4}:){7}[A-Fa-f0-9]{1,4}|(?:[A-Fa-f0-9]{1,4}:){1,7}:|(?:[A-Fa-f0-9]{1,4}:){1,6}:[A-Fa-f0-9]{1,4}|(?:[A-Fa-f0-9]{1,4}:){1,5}(?::[A-Fa-f0-9]{1,4}){1,2}|(?:[A-Fa-f0-9]{1,4}:){1,4}(?::[A-Fa-f0-9]{1,4}){1,3}|(?:[A-Fa-f0-9]{1,4}:){1,3}(?::[A-Fa-f0-9]{1,4}){1,4}|(?:[A-Fa-f0-9]{1,4}:){1,2}(?::[A-Fa-f0-9]{1,4}){1,5}|[A-Fa-f0-9]{1,4}:(?::[A-Fa-f0-9]{1,4}){1,6}|:(?::[A-Fa-f0-9]{1,4}){1,7}|::(?:[A-Fa-f0-9]{1,4}:){1,5}|::(?:[A-Fa-f0-9]{1,4}:){1,4}|::(?:[A-Fa-f0-9]{1,4}:){1,3}|::(?:[A-Fa-f0-9]{1,4}:){1,2}|::[A-Fa-f0-9]{1,4}|::$");
    private final boolean isWhite;
    private final Set<String> list = new HashSet<String>();
    private final boolean allowIp;

    public NetworkControl(NetworkProperties properties) {
        Set<String> white = properties.getWhite();
        Set<String> black = properties.getBlack();
        this.isWhite = black == null || black.isEmpty();
        this.list.addAll(this.isWhite ? white : black);
        this.allowIp = Boolean.TRUE.equals(properties.getAllowIp());
    }

    public boolean isReject(String host) {
        return CACHE.computeIfAbsent(host, k -> {
            String value;
            String string = value = k.endsWith(".") ? k.substring(0, k.length() - 1) : k;
            if (this.isContains(value)) {
                return !this.isWhite;
            }
            if (this.isIp(value)) {
                return !this.allowIp;
            }
            return this.isWhite;
        });
    }

    public boolean isContains(String host) {
        for (String raw : this.list) {
            if (!Objects.equals(raw, host) && !host.endsWith(raw)) continue;
            return true;
        }
        return false;
    }

    public boolean isIp(String host) {
        if (IPV4_PATTERN.matcher(host).matches()) {
            return true;
        }
        return IPV6_PATTERN.matcher(host).matches();
    }
}

