/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.minecraft.security.launcher;

import java.nio.file.Path;
import live.lingting.minecraft.security.Reflection;
import live.lingting.minecraft.security.enums.LaunchType;
import live.lingting.minecraft.security.launcher.DefaultLauncher;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;

public class FabricLauncher
extends DefaultLauncher
implements ClientModInitializer {
    public void onInitializeClient() {
        Path gameDir = FabricLoader.getInstance().getGameDir();
        String mcVersion = this.getMcVersion();
        if (mcVersion == null) {
            this.log.warn("Minecraft version not found");
            return;
        }
        this.init(gameDir, mcVersion, LaunchType.FABRIC);
    }

    private String getMcVersion() {
        Object instance = null;
        try {
            instance = Reflection.get("net.fabricmc.loader.impl.FabricLoaderImpl", "INSTANCE");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            instance = Reflection.get("org.quiltmc.loader.impl.QuiltLoaderImpl", "INSTANCE");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (instance != null) {
            try {
                Object provider = Reflection.method(instance, "getGameProvider");
                return (String)Reflection.method(provider, "getNormalizedGameVersion");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

