/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.minecraft.security.launcher;

import com.google.gson.JsonObject;
import cpw.mods.modlauncher.ArgumentHandler;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.IncompatibleEnvironmentException;
import cpw.mods.modlauncher.api.TypesafeMap;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import live.lingting.minecraft.security.Reflection;
import live.lingting.minecraft.security.enums.LaunchType;
import live.lingting.minecraft.security.launcher.DefaultLauncher;
import live.lingting.minecraft.security.util.JsonUtils;
import org.jetbrains.annotations.NotNull;

public class ModLauncher
extends DefaultLauncher
implements ITransformationService {
    @NotNull
    public String name() {
        return "LingtingMinecraftSecurity";
    }

    public void initialize(IEnvironment environment) {
        this.log.debug("initialize by ModLauncher");
        Optional minecraftPath = environment.getProperty((TypesafeMap.Key)IEnvironment.Keys.GAMEDIR.get());
        if (!minecraftPath.isPresent()) {
            this.log.warn("Minecraft path not found");
            return;
        }
        String minecraftVersion = this.getMinecraftVersion();
        if (minecraftVersion == null) {
            this.log.warn("Minecraft version not found");
            return;
        }
        this.init((Path)minecraftPath.get(), minecraftVersion, LaunchType.FORGE);
    }

    public void beginScanning(IEnvironment environment) {
    }

    public void onLoad(IEnvironment env, Set<String> otherServices) throws IncompatibleEnvironmentException {
    }

    @NotNull
    public List<ITransformer> transformers() {
        return Collections.emptyList();
    }

    private String getMinecraftVersion() {
        String string;
        block11: {
            try {
                ArgumentHandler handler = (ArgumentHandler)Reflection.get(Launcher.INSTANCE, "argumentHandler");
                String[] args = (String[])Reflection.get(handler, "args");
                Optional<String> optional = Arrays.stream(args).filter(arg -> arg.equalsIgnoreCase("--fml.mcversion")).findFirst();
                if (optional.isPresent()) {
                    return optional.get();
                }
            }
            catch (Exception e) {
                this.log.warn("Error getting minecraft version: %s", (Throwable)e);
            }
            Class<?> clazz = Class.forName("net.minecraftforge.fml.loading.FMLLoader");
            InputStream is = clazz.getResourceAsStream("/forge_version.json");
            try {
                JsonObject object = JsonUtils.toObj(is, JsonObject.class);
                string = object.get("mc").getAsString();
                if (is == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.log.warn("Error getting minecraft version: %s", (Throwable)e);
                    return null;
                }
            }
            is.close();
        }
        return string;
    }
}

