/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.minecraft.security.launcher;

import java.io.File;
import java.util.List;
import live.lingting.minecraft.security.Reflection;
import live.lingting.minecraft.security.enums.LaunchType;
import live.lingting.minecraft.security.launcher.DefaultLauncher;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class TweakLauncher
extends DefaultLauncher
implements ITweaker {
    public void acceptOptions(List<String> args, File gameDir, File assetsDir, String profile) {
        String mcVersion = this.getMcVersion();
        if (mcVersion == null) {
            this.log.warn("Failed to get minecraft version.");
            return;
        }
        this.init(gameDir.toPath(), mcVersion, LaunchType.FORGE);
    }

    public void injectIntoClassLoader(LaunchClassLoader classLoader) {
    }

    public String getLaunchTarget() {
        return "";
    }

    public String[] getLaunchArguments() {
        return new String[0];
    }

    String getMcVersion() {
        try {
            return (String)Reflection.get("cpw.mods.fml.relauncher.FMLInjectionData", "mccversion");
        }
        catch (Exception exception) {
            try {
                return (String)Reflection.get("net.minecraftforge.fml.relauncher.FMLInjectionData", "mccversion");
            }
            catch (Exception exception2) {
                try {
                    return (String)Reflection.get("net.minecraftforge.common.ForgeVersion", "mcVersion");
                }
                catch (Exception exception3) {
                    return null;
                }
            }
        }
    }
}

