/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.block;

import mekanism.additions.common.block.ExtendedFluidLogType;
import mekanism.common.block.states.IFluidLogType;
import mekanism.common.block.states.IStateFluidLoggable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

public interface IStateExtendedFluidLoggable
extends IStateFluidLoggable {
    public static final EnumProperty<ExtendedFluidLogType> FLUID_LOGGED = EnumProperty.create((String)"fluid_logged_extension", ExtendedFluidLogType.class);

    default public boolean isValidFluid(@NotNull Fluid fluid) {
        return fluid == Fluids.WATER || super.isValidFluid(fluid);
    }

    @NotNull
    default public EnumProperty<? extends IFluidLogType> getFluidLoggedProperty() {
        return FLUID_LOGGED;
    }

    @NotNull
    default public FluidState getFluid(@NotNull BlockState state) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            return Fluids.WATER.defaultFluidState();
        }
        return super.getFluid(state);
    }

    default public boolean canPlaceLiquid(Player player, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Fluid fluid) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) == false && super.canPlaceLiquid(player, world, pos, state, fluid);
    }

    default public boolean placeLiquid(@NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull FluidState fluidState) {
        Fluid fluid = fluidState.getType();
        if (this.canPlaceLiquid(null, (BlockGetter)world, pos, state, fluid)) {
            if (!world.isClientSide()) {
                if (fluid == Fluids.WATER) {
                    world.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                } else {
                    world.setBlock(pos, this.setState(state, fluid), 3);
                }
                world.scheduleTick(pos, fluid, fluid.getTickDelay((LevelReader)world));
            }
            return true;
        }
        return false;
    }

    @NotNull
    default public ItemStack pickupBlock(Player player, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockState state) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            world.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            return new ItemStack((ItemLike)Items.WATER_BUCKET);
        }
        return super.pickupBlock(player, world, pos, state);
    }
}

