/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.config;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import mekanism.additions.common.config.AdditionsConfigTranslations;
import mekanism.additions.common.entity.baby.BabyType;
import mekanism.additions.common.registries.AdditionsEntityTypes;
import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedBooleanValue;
import mekanism.common.config.value.CachedDoubleValue;
import mekanism.common.config.value.CachedFloatValue;
import mekanism.common.config.value.CachedIntValue;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class AdditionsConfig
extends BaseMekanismConfig {
    private final ModConfigSpec configSpec;
    public final CachedIntValue obsidianTNTDelay;
    public final CachedFloatValue obsidianTNTBlastRadius;
    public final CachedDoubleValue babyArrowDamageMultiplier;
    public final CachedBooleanValue voiceServerEnabled;
    public final CachedIntValue voicePort;
    private final Map<BabyType, SpawnConfig> spawnConfigs = new EnumMap<BabyType, SpawnConfig>(BabyType.class);

    AdditionsConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        AdditionsConfigTranslations.SERVER_OBSIDIAN_TNT.applyToBuilder(builder).push("obsidian_tnt");
        this.obsidianTNTDelay = CachedIntValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)AdditionsConfigTranslations.SERVER_OBSIDIAN_DELAY.applyToBuilder(builder).defineInRange("delay", 100, 0, Integer.MAX_VALUE));
        this.obsidianTNTBlastRadius = CachedFloatValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)AdditionsConfigTranslations.SERVER_OBSIDIAN_RADIUS.applyToBuilder(builder).defineInRange("blastRadius", 12.0, 0.1, 1000.0));
        builder.pop();
        AdditionsConfigTranslations.SERVER_VOICE.applyToBuilder(builder).push("voice_server");
        this.voiceServerEnabled = CachedBooleanValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)AdditionsConfigTranslations.SERVER_VOICE_ENABLED.applyToBuilder(builder).worldRestart().define("enabled", false));
        this.voicePort = CachedIntValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)AdditionsConfigTranslations.SERVER_VOICE_PORT.applyToBuilder(builder).defineInRange("voicePort", 36123, 1, 65535));
        builder.pop();
        AdditionsConfigTranslations.SERVER_BABY.applyToBuilder(builder).push("baby_mobs");
        this.babyArrowDamageMultiplier = CachedDoubleValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)AdditionsConfigTranslations.SERVER_BABY_ARROW_DAMAGE.applyToBuilder(builder).defineInRange("arrowDamageMultiplier", 0.25, 0.1, 10.0));
        this.addBabyTypeConfig(BabyType.BOGGED, builder, (Holder<EntityType<?>>)AdditionsEntityTypes.BABY_BOGGED, (EntityType<?>)EntityType.BOGGED);
        this.addBabyTypeConfig(BabyType.CREEPER, builder, (Holder<EntityType<?>>)AdditionsEntityTypes.BABY_CREEPER, (EntityType<?>)EntityType.CREEPER);
        this.addBabyTypeConfig(BabyType.ENDERMAN, builder, (Holder<EntityType<?>>)AdditionsEntityTypes.BABY_ENDERMAN, (EntityType<?>)EntityType.ENDERMAN);
        this.addBabyTypeConfig(BabyType.SKELETON, builder, (Holder<EntityType<?>>)AdditionsEntityTypes.BABY_SKELETON, (EntityType<?>)EntityType.SKELETON);
        this.addBabyTypeConfig(BabyType.STRAY, builder, (Holder<EntityType<?>>)AdditionsEntityTypes.BABY_STRAY, (EntityType<?>)EntityType.STRAY);
        this.addBabyTypeConfig(BabyType.WITHER_SKELETON, builder, (Holder<EntityType<?>>)AdditionsEntityTypes.BABY_WITHER_SKELETON, (EntityType<?>)EntityType.WITHER_SKELETON);
        builder.pop();
        this.configSpec = builder.build();
    }

    private void addBabyTypeConfig(BabyType type, ModConfigSpec.Builder builder, Holder<EntityType<?>> entityTypeProvider, EntityType<?> parentType) {
        this.spawnConfigs.put(type, new SpawnConfig((IMekanismConfig)this, builder, "baby_" + type.getSerializedName(), entityTypeProvider, parentType));
    }

    public String getFileName() {
        return "additions";
    }

    public String getTranslation() {
        return "General Config";
    }

    public ModConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }

    public SpawnConfig getConfig(BabyType babyType) {
        return this.spawnConfigs.get((Object)babyType);
    }

    public static class SpawnConfig {
        public final CachedBooleanValue shouldSpawn;
        public final CachedDoubleValue minSizePercentage;
        public final CachedDoubleValue maxSizePercentage;
        public final CachedDoubleValue weightPercentage;
        public final CachedDoubleValue spawnCostPerEntityPercentage;
        public final CachedDoubleValue maxSpawnCostPercentage;
        public final Holder<EntityType<?>> entityType;
        public final EntityType<?> parentType;

        private SpawnConfig(IMekanismConfig config, ModConfigSpec.Builder builder, String name, Holder<EntityType<?>> entityType, EntityType<?> parentType) {
            this.entityType = entityType;
            this.parentType = parentType;
            AdditionsConfigTranslations.BabySpawnTranslations translations = AdditionsConfigTranslations.BabySpawnTranslations.create(name);
            translations.topLevel().applyToBuilder(builder).push(name);
            this.shouldSpawn = CachedBooleanValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)translations.shouldSpawn().applyToBuilder(builder).worldRestart().define("shouldSpawn", true));
            this.minSizePercentage = CachedDoubleValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)translations.minSize().applyToBuilder(builder).worldRestart().defineInRange("minSizePercentage", 0.5, 0.0, 100.0));
            this.maxSizePercentage = CachedDoubleValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)translations.maxSize().applyToBuilder(builder).worldRestart().defineInRange("maxSizePercentage", 0.5, 0.0, 100.0));
            this.weightPercentage = CachedDoubleValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)translations.weight().applyToBuilder(builder).worldRestart().defineInRange("weightPercentage", 0.05, 0.0, 100.0));
            this.spawnCostPerEntityPercentage = CachedDoubleValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)translations.costPerEntity().applyToBuilder(builder).worldRestart().defineInRange("spawnCostPerEntityPercentage", 1.0, 0.0, 100.0));
            this.maxSpawnCostPercentage = CachedDoubleValue.wrap((IMekanismConfig)config, (ModConfigSpec.ConfigValue)translations.maxCost().applyToBuilder(builder).worldRestart().defineInRange("maxSpawnCostPercentage", 1.0, 0.0, 100.0));
            builder.pop();
        }

        public MobSpawnSettings.SpawnerData getSpawner(MobSpawnSettings.SpawnerData parentEntry) {
            int weight = Mth.ceil((double)((double)parentEntry.getWeight().asInt() * this.weightPercentage.get()));
            int minSize = Mth.ceil((double)((double)parentEntry.minCount * this.minSizePercentage.get()));
            int maxSize = Mth.ceil((double)((double)parentEntry.maxCount * this.maxSizePercentage.get()));
            return new MobSpawnSettings.SpawnerData((EntityType)this.entityType.value(), weight, minSize, Math.max(minSize, maxSize));
        }

        public List<MobSpawnSettings.SpawnerData> getSpawnersToAdd(List<MobSpawnSettings.SpawnerData> monsterSpawns) {
            ArrayList<MobSpawnSettings.SpawnerData> list = new ArrayList<MobSpawnSettings.SpawnerData>();
            for (MobSpawnSettings.SpawnerData monsterSpawn : monsterSpawns) {
                if (monsterSpawn.type != this.parentType) continue;
                list.add(this.getSpawner(monsterSpawn));
            }
            return list;
        }
    }
}

