/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.entity;

import java.util.Optional;
import java.util.UUID;
import java.util.function.IntFunction;
import mekanism.additions.common.AdditionsTags;
import mekanism.additions.common.registries.AdditionsEntityTypes;
import mekanism.additions.common.registries.AdditionsItems;
import mekanism.additions.common.registries.AdditionsSounds;
import mekanism.api.text.EnumColor;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class EntityBalloon
extends Entity
implements IEntityWithComplexSpawn {
    private static final EntityDataAccessor<Byte> IS_LATCHED = SynchedEntityData.defineId(EntityBalloon.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Integer> LATCHED_X = SynchedEntityData.defineId(EntityBalloon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> LATCHED_Y = SynchedEntityData.defineId(EntityBalloon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> LATCHED_Z = SynchedEntityData.defineId(EntityBalloon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> LATCHED_ID = SynchedEntityData.defineId(EntityBalloon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final float OFFSET = -0.275f;
    private EnumColor color = EnumColor.DARK_BLUE;
    private BlockPos latched;
    public LivingEntity latchedEntity;
    private boolean hasCachedEntity;
    private UUID cachedEntityUUID;

    public EntityBalloon(EntityType<EntityBalloon> type, Level world) {
        super(type, world);
        this.noCulling = true;
        this.blocksBuilding = true;
        this.setPos(this.getX() + 0.5, this.getY() + 3.0, this.getZ() + 0.5);
        this.setDeltaMovement(this.getDeltaMovement().x(), 0.04, this.getDeltaMovement().z());
    }

    @Nullable
    public static EntityBalloon create(Level world, double x, double y, double z, EnumColor c) {
        EntityBalloon balloon = (EntityBalloon)((EntityType)AdditionsEntityTypes.BALLOON.get()).create(world);
        if (balloon == null) {
            return null;
        }
        balloon.setPos(x + 0.5, y + 3.0, z + 0.5);
        balloon.xo = balloon.getX();
        balloon.yo = balloon.getY();
        balloon.zo = balloon.getZ();
        balloon.color = c;
        return balloon;
    }

    @Nullable
    public static EntityBalloon create(LivingEntity entity, EnumColor c) {
        EntityBalloon balloon = (EntityBalloon)((EntityType)AdditionsEntityTypes.BALLOON.get()).create(entity.level());
        if (balloon == null) {
            return null;
        }
        balloon.latchedEntity = entity;
        float height = balloon.latchedEntity.getBbHeight();
        balloon.setPos(balloon.latchedEntity.getX(), balloon.latchedEntity.getY() + (double)height + (double)1.7f, balloon.latchedEntity.getZ());
        balloon.xo = balloon.getX();
        balloon.yo = balloon.getY();
        balloon.zo = balloon.getZ();
        balloon.color = c;
        balloon.entityData.set(IS_LATCHED, (Object)2);
        balloon.entityData.set(LATCHED_ID, (Object)entity.getId());
        return balloon;
    }

    @Nullable
    public static EntityBalloon create(Level world, BlockPos pos, EnumColor c) {
        EntityBalloon balloon = (EntityBalloon)((EntityType)AdditionsEntityTypes.BALLOON.get()).create(world);
        if (balloon == null) {
            return null;
        }
        balloon.latched = pos;
        balloon.setPos((float)balloon.latched.getX() + 0.5f, (float)balloon.latched.getY() + 1.8f, (float)balloon.latched.getZ() + 0.5f);
        balloon.xo = balloon.getX();
        balloon.yo = balloon.getY();
        balloon.zo = balloon.getZ();
        balloon.color = c;
        balloon.entityData.set(IS_LATCHED, (Object)1);
        balloon.entityData.set(LATCHED_X, (Object)balloon.latched.getX());
        balloon.entityData.set(LATCHED_Y, (Object)balloon.latched.getY());
        balloon.entityData.set(LATCHED_Z, (Object)balloon.latched.getZ());
        return balloon;
    }

    public EnumColor getColor() {
        return this.color;
    }

    public void tick() {
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        if (this.getY() >= (double)this.level().getMaxBuildHeight()) {
            this.pop();
            return;
        }
        if (this.level().isClientSide) {
            this.latched = (Byte)this.entityData.get(IS_LATCHED) == 1 ? new BlockPos(((Integer)this.entityData.get(LATCHED_X)).intValue(), ((Integer)this.entityData.get(LATCHED_Y)).intValue(), ((Integer)this.entityData.get(LATCHED_Z)).intValue()) : null;
            this.latchedEntity = (Byte)this.entityData.get(IS_LATCHED) == 2 ? (LivingEntity)this.level().getEntity(((Integer)this.entityData.get(LATCHED_ID)).intValue()) : null;
        } else {
            if (this.hasCachedEntity) {
                ServerLevel serverLevel;
                Entity entity;
                Level level = this.level();
                if (level instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).getEntity(this.cachedEntityUUID)) instanceof LivingEntity) {
                    this.latchedEntity = (LivingEntity)entity;
                }
                this.cachedEntityUUID = null;
                this.hasCachedEntity = false;
            }
            if (this.tickCount == 1) {
                byte isLatched = this.latched != null ? (byte)1 : (this.latchedEntity != null ? (byte)2 : 0);
                this.entityData.set(IS_LATCHED, (Object)isLatched);
                this.entityData.set(LATCHED_X, (Object)(this.latched == null ? 0 : this.latched.getX()));
                this.entityData.set(LATCHED_Y, (Object)(this.latched == null ? 0 : this.latched.getY()));
                this.entityData.set(LATCHED_Z, (Object)(this.latched == null ? 0 : this.latched.getZ()));
                this.entityData.set(LATCHED_ID, (Object)(this.latchedEntity == null ? -1 : this.latchedEntity.getId()));
            }
        }
        if (!this.level().isClientSide) {
            Optional blockState;
            if (this.latched != null && (blockState = WorldUtils.getBlockState((BlockGetter)this.level(), (BlockPos)this.latched)).isPresent() && ((BlockState)blockState.get()).isAir()) {
                this.latched = null;
                this.entityData.set(IS_LATCHED, (Object)0);
            }
            if (this.latchedEntity != null && !this.latchedEntity.isAlive()) {
                this.latchedEntity = null;
                this.entityData.set(IS_LATCHED, (Object)0);
            }
        }
        if (!this.isLatched()) {
            motion = this.getDeltaMovement();
            this.setDeltaMovement(motion.x(), Math.min(motion.y() * (double)1.02f, (double)0.2f), motion.z());
            this.move(MoverType.SELF, this.getDeltaMovement());
            motion = this.getDeltaMovement();
            motion = motion.multiply(0.98, 0.0, 0.98);
            if (this.onGround()) {
                motion = motion.multiply(0.7, 0.0, 0.7);
            }
            if (motion.y() == 0.0) {
                motion = motion.add(0.0, 0.04, 0.0);
            }
            this.setDeltaMovement(motion);
        } else if (this.latched != null) {
            this.setDeltaMovement(0.0, 0.0, 0.0);
        } else if (this.latchedEntity != null && this.latchedEntity.getHealth() > 0.0f) {
            if (!this.isFlying((Entity)this.latchedEntity)) {
                motion = this.latchedEntity.getDeltaMovement();
                double targetElevation = this.getTargetElevation(this.latchedEntity);
                if (this.latchedEntity.getY() - (double)1.0E-5f < targetElevation) {
                    this.latchedEntity.setDeltaMovement(motion.x(), Math.max(0.04, motion.y() * 1.015), motion.z());
                    this.latchedEntity.hasImpulse = true;
                } else if (this.latchedEntity.getY() - 0.1 > targetElevation) {
                    this.latchedEntity.setDeltaMovement(motion.x(), Math.min(-0.04, motion.y() * 1.015), motion.z());
                    this.latchedEntity.hasImpulse = true;
                } else {
                    this.latchedEntity.setDeltaMovement(motion.x(), 0.0, motion.z());
                }
            }
            this.setPos(this.latchedEntity.getX(), this.latchedEntity.getY() + this.getAddedHeight(), this.latchedEntity.getZ());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isFlying(Entity entity) {
        if (!(entity instanceof Player)) return false;
        Player player = (Player)entity;
        if (!player.getAbilities().flying) return false;
        return true;
    }

    public double getAddedHeight() {
        return (double)this.latchedEntity.getBbHeight() + 0.8;
    }

    private double getTargetElevation(LivingEntity entity) {
        BlockPos pos = BlockPos.containing((Position)entity.position());
        BlockPos.MutableBlockPos posi = new BlockPos.MutableBlockPos(pos.getX(), pos.getY(), pos.getZ());
        CollisionContext collisionContext = CollisionContext.of((Entity)entity);
        while (posi.getY() > 0) {
            double stateOffset;
            BlockState state;
            if (posi.getY() < this.level().getMaxBuildHeight() && !(state = this.level().getBlockState((BlockPos)posi)).isAir() && !Double.isInfinite(stateOffset = state.getCollisionShape((BlockGetter)this.level(), (BlockPos)posi, collisionContext).max(Direction.Axis.Y)) && stateOffset != 0.0) {
                double floor = (double)posi.getY() + stateOffset;
                return floor + (double)Math.min(4, Mth.ceil((float)entity.getBbHeight()));
            }
            posi.move(Direction.DOWN);
        }
        return 0.0;
    }

    private void pop() {
        this.playSound((SoundEvent)AdditionsSounds.POP.get(), 1.0f, 1.0f);
        if (!this.level().isClientSide) {
            Vector3f col = new Vector3f(this.color.getColor(0), this.color.getColor(1), this.color.getColor(2));
            DustParticleOptions redstoneParticleData = new DustParticleOptions(col, 1.0f);
            Vec3 center = this.getBoundingBox().getCenter();
            for (int i = 0; i < 10; ++i) {
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)redstoneParticleData, center.x() + 0.6 * (double)this.random.nextFloat() - 0.3, center.y() + 0.6 * (double)this.random.nextFloat() - 0.3, center.z() + 0.6 * (double)this.random.nextFloat() - 0.3, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        this.level().gameEvent((Holder)GameEvent.ENTITY_DAMAGE, this.position(), GameEvent.Context.of((Entity)this));
        this.discard();
    }

    public boolean isPushable() {
        return this.latched == null;
    }

    public boolean isPickable() {
        return this.isAlive();
    }

    @NotNull
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        builder.define(IS_LATCHED, (Object)0);
        builder.define(LATCHED_X, (Object)0);
        builder.define(LATCHED_Y, (Object)0);
        builder.define(LATCHED_Z, (Object)0);
        builder.define(LATCHED_ID, (Object)-1);
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag nbtTags) {
        NBTUtils.setEnumIfPresent((CompoundTag)nbtTags, (String)"color", (IntFunction)EnumColor.BY_ID, color -> {
            this.color = color;
        });
        NBTUtils.setBlockPosIfPresent((CompoundTag)nbtTags, (String)"latched", pos -> {
            this.latched = pos;
        });
        NBTUtils.setUUIDIfPresent((CompoundTag)nbtTags, (String)"owner", uuid -> {
            this.hasCachedEntity = true;
            this.cachedEntityUUID = uuid;
        });
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag nbtTags) {
        NBTUtils.writeEnum((CompoundTag)nbtTags, (String)"color", (Enum)this.color);
        if (this.latched != null) {
            nbtTags.put("latched", NbtUtils.writeBlockPos((BlockPos)this.latched));
        }
        if (this.latchedEntity != null) {
            nbtTags.putUUID("owner", this.latchedEntity.getUUID());
        }
    }

    public boolean skipAttackInteraction(@NotNull Entity entity) {
        this.pop();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            CriteriaTriggers.PLAYER_KILLED_ENTITY.trigger(player, (Entity)this, this.damageSources().playerAttack((Player)player));
        }
        return true;
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)this.color);
        if (this.latched != null) {
            buffer.writeByte((byte)1);
            buffer.writeBlockPos(this.latched);
        } else if (this.latchedEntity != null) {
            buffer.writeByte((byte)2);
            buffer.writeVarInt(this.latchedEntity.getId());
        } else {
            buffer.writeByte((byte)0);
        }
    }

    public void readSpawnData(RegistryFriendlyByteBuf buffer) {
        this.color = (EnumColor)buffer.readEnum(EnumColor.class);
        byte type = buffer.readByte();
        if (type == 1) {
            this.latched = buffer.readBlockPos();
        } else if (type == 2) {
            this.latchedEntity = (LivingEntity)this.level().getEntity(buffer.readVarInt());
        } else {
            this.latched = null;
        }
    }

    public void remove(@NotNull Entity.RemovalReason reason) {
        super.remove(reason);
        if (this.latchedEntity != null) {
            this.latchedEntity.hasImpulse = false;
        }
    }

    public boolean shouldRenderAtSqrDistance(double dist) {
        return dist <= 64.0;
    }

    public boolean shouldRender(double x, double y, double z) {
        return true;
    }

    public boolean isInvulnerableTo(@NotNull DamageSource source) {
        return source.is(AdditionsTags.DamageTypes.BALLOON_INVULNERABLE) || super.isInvulnerableTo(source);
    }

    public boolean hurt(@NotNull DamageSource dmgSource, float damage) {
        if (this.isInvulnerableTo(dmgSource)) {
            return false;
        }
        this.pop();
        Entity entity = dmgSource.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            CriteriaTriggers.PLAYER_KILLED_ENTITY.trigger(player, (Entity)this, dmgSource);
        }
        return true;
    }

    public boolean isLatched() {
        if (this.level().isClientSide) {
            return (Byte)this.entityData.get(IS_LATCHED) > 0;
        }
        return this.latched != null || this.latchedEntity != null;
    }

    public boolean isLatchedToEntity() {
        return (Byte)this.entityData.get(IS_LATCHED) == 2 && this.latchedEntity != null;
    }

    @NotNull
    protected AABB makeBoundingBox() {
        AABB boundingBox = super.makeBoundingBox();
        return boundingBox.setMinY(boundingBox.minY - (double)-0.275f).setMaxY(boundingBox.maxY - (double)-0.275f);
    }

    public void refreshDimensions() {
    }

    public ItemStack getPickedResult(HitResult target) {
        return AdditionsItems.BALLOONS.get(this.color).asStack();
    }
}

