/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.vineplicate.init;

import java.util.Map;
import net.mcreator.vineplicate.VineplicateMod;
import net.mcreator.vineplicate.init.VineplicateModScreens;
import net.mcreator.vineplicate.network.MenuStateUpdateMessage;
import net.mcreator.vineplicate.world.inventory.AggregatorGUIMenu;
import net.mcreator.vineplicate.world.inventory.AutomaticAggregatorGUIMenu;
import net.mcreator.vineplicate.world.inventory.IncubatorGUIMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class VineplicateModMenus {
    public static final DeferredRegister<MenuType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"vineplicate");
    public static final RegistryObject<MenuType<AggregatorGUIMenu>> AGGREGATOR_GUI = REGISTRY.register("aggregator_gui", () -> IForgeMenuType.create(AggregatorGUIMenu::new));
    public static final RegistryObject<MenuType<IncubatorGUIMenu>> INCUBATOR_GUI = REGISTRY.register("incubator_gui", () -> IForgeMenuType.create(IncubatorGUIMenu::new));
    public static final RegistryObject<MenuType<AutomaticAggregatorGUIMenu>> AUTOMATIC_AGGREGATOR_GUI = REGISTRY.register("automatic_aggregator_gui", () -> IForgeMenuType.create(AutomaticAggregatorGUIMenu::new));

    public static interface MenuAccessor {
        public Map<String, Object> getMenuState();

        public Map<Integer, Slot> getSlots();

        default public void sendMenuStateUpdate(Player player, int elementType, String name, Object elementState, boolean needClientUpdate) {
            this.getMenuState().put(elementType + ":" + name, elementState);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                VineplicateMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MenuStateUpdateMessage(elementType, name, elementState));
            } else if (player.m_9236_().f_46443_) {
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen instanceof VineplicateModScreens.ScreenAccessor) {
                    VineplicateModScreens.ScreenAccessor accessor = (VineplicateModScreens.ScreenAccessor)screen;
                    if (needClientUpdate) {
                        accessor.updateMenuState(elementType, name, elementState);
                    }
                }
                VineplicateMod.PACKET_HANDLER.sendToServer((Object)new MenuStateUpdateMessage(elementType, name, elementState));
            }
        }

        default public <T> T getMenuState(int elementType, String name, T defaultValue) {
            try {
                return (T)this.getMenuState().getOrDefault(elementType + ":" + name, defaultValue);
            }
            catch (ClassCastException e) {
                return defaultValue;
            }
        }
    }
}

