/*
 * Decompiled with CFR 0.152.
 */
package me.gamerduck.alwaysauth;

import java.nio.file.Path;
import me.gamerduck.alwaysauth.api.AuthDatabase;
import me.gamerduck.alwaysauth.api.SessionConfig;
import me.gamerduck.alwaysauth.api.SessionProxyServer;

public abstract class Platform<CS> {
    private final SessionProxyServer proxyServer;
    private SessionConfig config;
    private final Path platformFolder;
    public static Platform<?> mixinOnly$instance;

    public Platform(Path platformFolder) {
        this.platformFolder = platformFolder;
        mixinOnly$instance = this;
        try {
            this.config = new SessionConfig(platformFolder.toFile(), this);
            this.sendLogMessage("Configuration loaded: " + String.valueOf(this.config));
            if (this.config.getIpAddress().equalsIgnoreCase("127.0.0.1") || this.config.getIpAddress().equalsIgnoreCase("0.0.0.0")) {
                this.proxyServer = new SessionProxyServer(this.config.getPort(), platformFolder.toFile(), this, this.config);
                this.proxyServer.start();
                this.sendLogMessage("AlwaysAuth enabled! Proxy running on port " + this.config.getPort());
                this.sendLogMessage("Fallback mode: " + (this.config.isFallbackEnabled() ? "ENABLED" : "DISABLED"));
                this.sendLogMessage("Security level: " + this.config.getSecurityLevel().toUpperCase());
            } else {
                this.sendLogMessage("AlwaysAuth enabled! Using external domain " + this.config.getSessionServerUrl());
                this.proxyServer = null;
            }
        }
        catch (Exception e) {
            this.sendSevereLogMessage("Failed to enable AlwaysAuth" + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public abstract void sendMessage(CS var1, String var2);

    public abstract void sendLogMessage(String var1);

    public abstract void sendSevereLogMessage(String var1);

    public abstract void sendWarningLogMessage(String var1);

    public void onDisable() {
        if (this.proxyServer != null) {
            this.proxyServer.stop();
        }
        this.sendLogMessage("AlwaysAuth disabled");
    }

    public void cmdStatus(CS player) {
        this.sendMessage(player, "\u00a76\u00a7lAlwaysAuth Status");
        this.sendMessage(player, "\u00a77Proxy Port: \u00a7f" + this.config.getPort());
        this.sendMessage(player, "\u00a77Fallback: " + (this.config.isFallbackEnabled() ? "\u00a7aENABLED" : "\u00a7cDISABLED"));
        this.sendMessage(player, "\u00a77Security: \u00a7f" + this.config.getSecurityLevel().toUpperCase());
        if (this.config.getSecurityLevel().equals("medium")) {
            this.sendMessage(player, "\u00a77Max Offline Time: \u00a7f" + this.config.getMaxOfflineHours() + " hours");
        }
        this.sendMessage(player, "\u00a77Session URL: \u00a7f" + this.config.getSessionServerUrl());
    }

    public void cmdStats(CS player) {
        AuthDatabase.CacheStats stats = this.proxyServer.getDatabase().getStats();
        this.sendMessage(player, "\u00a76\u00a7lCache Statistics");
        this.sendMessage(player, "\u00a77Total Players: \u00a7f" + stats.totalPlayers);
        this.sendMessage(player, "\u00a77Active (24h): \u00a7f" + stats.recentPlayers);
    }

    public void cmdToggle(CS player) {
        this.config.setFallbackEnabled(!this.config.isFallbackEnabled());
        this.config.saveConfig();
        this.sendMessage(player, "\u00a76Fallback mode " + (this.config.isFallbackEnabled() ? "\u00a7aenabled" : "\u00a7cdisabled"));
    }

    public void cmdSecurity(CS player, String level) {
        if (!level.equals("basic") && !level.equals("medium")) {
            this.sendMessage(player, "\u00a7cInvalid security level. Use 'basic' or 'medium'");
        }
        this.config.setSecurityLevel(level);
        this.config.saveConfig();
        this.sendMessage(player, "\u00a76Security level set to: \u00a7f" + level.toUpperCase());
        if (level.equals("medium")) {
            this.sendMessage(player, "\u00a77Players must have logged in within " + this.config.getMaxOfflineHours() + " hours");
        }
    }

    public void cmdCleanup(CS player) {
        int cleaned = this.proxyServer.getDatabase().cleanOldEntries(this.config.getCleanupDays());
        this.sendMessage(player, "\u00a76Cleaned \u00a7f" + cleaned + "\u00a76 old entries (older than " + this.config.getCleanupDays() + " days)");
    }

    public void cmdReload(CS player) {
        this.config = new SessionConfig(this.platformFolder.toFile(), this);
        this.sendMessage(player, "\u00a76Configuration reloaded");
    }

    public void cmdDefault(CS player) {
        this.sendMessage(player, "\u00a7cUnknown subcommand. Use /alwaysauth for help");
    }

    public void cmdHelp(CS player) {
        this.sendMessage(player, "\u00a76\u00a7lAlways Auth");
        this.sendMessage(player, "\u00a77Commands:");
        this.sendMessage(player, "\u00a7e/alwaysauth status \u00a77- Show current status");
        this.sendMessage(player, "\u00a7e/alwaysauth stats \u00a77- Show cache statistics");
        this.sendMessage(player, "\u00a7e/alwaysauth toggle \u00a77- Enable/disable fallback");
        this.sendMessage(player, "\u00a7e/alwaysauth security <basic|medium> \u00a77- Set security level");
        this.sendMessage(player, "\u00a7e/alwaysauth cleanup \u00a77- Clean old cache entries");
        this.sendMessage(player, "\u00a7e/alwaysauth reload \u00a77- Reload configuration");
    }

    public SessionProxyServer proxyServer() {
        return this.proxyServer;
    }

    public SessionConfig config() {
        return this.config;
    }

    public Path platformFolder() {
        return this.platformFolder;
    }
}

