/*
 * Decompiled with CFR 0.152.
 */
package me.gamerduck.alwaysauth.api;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import me.gamerduck.alwaysauth.Platform;

public class SessionConfig {
    private final LinkedHashMap<String, String> properties;
    private final LinkedHashMap<String, String> comments;
    private final File configFile;
    private final Platform platform;
    private static final String DEFAULT_IP_ADDRESS = "http://127.0.0.1";
    private static final int DEFAULT_PORT = 8765;
    private static final boolean DEFAULT_FALLBACK_ENABLED = true;
    private static final int DEFAULT_MAX_OFFLINE_HOURS = 72;
    private static final int DEFAULT_CLEANUP_DAYS = 30;
    private static final String DEFAULT_DB_TYPE = "h2";
    private static final String DEFAULT_DB_HOST = "localhost";
    private static final int DEFAULT_DB_PORT_MYSQL = 3306;
    private static final int DEFAULT_DB_PORT_POSTGRESQL = 5432;
    private static final String DEFAULT_DB_NAME = "minecraft";
    private static final String DEFAULT_DB_USERNAME = "root";
    private static final String DEFAULT_DB_PASSWORD = "";
    private static final String DEFAULT_UPSTREAM_SESSION_SERVER = "https://sessionserver.mojang.com";

    public SessionConfig(File dataFolder, Platform platform) {
        this.configFile = new File(dataFolder, "config.properties");
        this.platform = platform;
        this.properties = new LinkedHashMap();
        this.comments = new LinkedHashMap();
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        this.loadConfig();
    }

    private void loadConfig() {
        this.setDefaults();
        if (this.configFile.exists()) {
            LinkedHashMap<String, String> defaults = new LinkedHashMap<String, String>(this.properties);
            LinkedHashMap<String, String> defaultComments = new LinkedHashMap<String, String>(this.comments);
            this.properties.clear();
            this.comments.clear();
            try (BufferedReader reader = new BufferedReader(new FileReader(this.configFile));){
                String line;
                String lastComment = null;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    if (line.startsWith("#")) {
                        lastComment = line.substring(1).trim();
                        continue;
                    }
                    int equalsIndex = line.indexOf(61);
                    if (equalsIndex <= 0) continue;
                    String key = line.substring(0, equalsIndex).trim();
                    String string = line.substring(equalsIndex + 1).trim();
                    this.properties.put(key, string);
                    if (lastComment == null) continue;
                    this.comments.put(key, lastComment);
                    lastComment = null;
                }
                boolean configChanged = false;
                for (String string : defaults.keySet()) {
                    if (this.properties.containsKey(string)) continue;
                    this.properties.put(string, defaults.get(string));
                    this.comments.put(string, defaultComments.get(string));
                    configChanged = true;
                    this.platform.sendLogMessage("Added new config option: " + string);
                }
                LinkedHashMap<String, String> filtered = new LinkedHashMap<String, String>();
                for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                    if (defaults.containsKey(entry.getKey())) {
                        filtered.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    configChanged = true;
                    this.platform.sendLogMessage("Removed deprecated config option: " + entry.getKey());
                }
                for (String string : filtered.keySet()) {
                    String oldComment = this.comments.get(string);
                    String newComment = defaultComments.get(string);
                    if ((oldComment == null || oldComment.isEmpty()) && newComment != null && !newComment.isEmpty()) {
                        this.comments.put(string, newComment);
                        configChanged = true;
                        continue;
                    }
                    if (oldComment != null && !oldComment.isEmpty() && (newComment == null || newComment.isEmpty())) {
                        this.comments.remove(string);
                        configChanged = true;
                        continue;
                    }
                    if (oldComment == null || newComment == null || oldComment.equals(newComment)) continue;
                    this.comments.put(string, newComment);
                    configChanged = true;
                }
                LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                for (String key : defaults.keySet()) {
                    if (!filtered.containsKey(key)) continue;
                    linkedHashMap.put(key, (String)filtered.get(key));
                }
                this.properties.clear();
                this.properties.putAll(linkedHashMap);
                if (configChanged) {
                    this.platform.sendLogMessage("Configuration updated, saving changes...");
                    this.saveConfig();
                }
                this.platform.sendLogMessage("Configuration loaded from " + this.configFile.getName());
            }
            catch (IOException e) {
                this.platform.sendSevereLogMessage("Failed to load config, using defaults: " + e.getMessage());
                this.properties.clear();
                this.properties.putAll(defaults);
                this.comments.clear();
                this.comments.putAll(defaultComments);
                this.saveConfig();
            }
        } else {
            this.saveConfig();
        }
    }

    private void setDefaults() {
        this.properties.clear();
        this.comments.clear();
        this.setProperty("ip-address", DEFAULT_IP_ADDRESS, "The ip for the session server\n# If set anything other than 127.0.0.1 or 0.0.0.0 (allows public access), it will treat as external server\n# An external server means only port needs to be set (to match that external server) and it will use that to authenticate.\n# Please note as of right now you will not see console logs on the server if you are using an external server");
        this.setProperty("port", String.valueOf(8765), "Port for the session server");
        this.setProperty("fallback-enabled", String.valueOf(true), "Enable session fallback when Mojang servers are down");
        this.setProperty("max-offline-hours", String.valueOf(72), "Maximum hours a player can stay offline before requiring re-authentication (0 = always require)");
        this.setProperty("cleanup-days", String.valueOf(30), "Days before old session data is cleaned up");
        this.setProperty("security-level", "basic", "Security level: 'basic' (always verify) or 'medium' (use max-offline-hours)");
        this.setProperty("upstream-server", DEFAULT_UPSTREAM_SESSION_SERVER, "Upstream Session Server URL\n# Default is Mojang's official one but this option is here to work with things like minehut's external servers");
        this.setProperty("database.type", DEFAULT_DB_TYPE, "Database type: h2, mysql, or mariadb");
        this.setProperty("database.host", DEFAULT_DB_HOST, "Database host (not used for H2)");
        this.setProperty("database.port", String.valueOf(3306), "Database port (not used for H2)");
        this.setProperty("database.name", DEFAULT_DB_NAME, "Database name (The file name for H2)");
        this.setProperty("database.username", DEFAULT_DB_USERNAME, "Database username (not used for H2)");
        this.setProperty("database.password", DEFAULT_DB_PASSWORD, "Database password (not used for H2)");
    }

    private void setProperty(String key, String value, String comment) {
        this.properties.put(key, value);
        if (comment != null && !comment.isEmpty()) {
            if (comment.contains("\n")) {
                Arrays.stream(comment.split("\n")).forEachOrdered(line -> this.comments.put(key, comment));
            } else {
                this.comments.put(key, comment);
            }
        }
    }

    public void saveConfig() {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.configFile));){
            writer.write("###################################");
            writer.newLine();
            writer.write("#                                 #");
            writer.newLine();
            writer.write("#    Always Auth Configuration    #");
            writer.newLine();
            writer.write("#                                 #");
            writer.newLine();
            writer.write("###################################");
            writer.newLine();
            writer.newLine();
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (this.comments.containsKey(key)) {
                    writer.write("# " + this.comments.get(key));
                    writer.newLine();
                }
                writer.write(key + "=" + value);
                writer.newLine();
                writer.newLine();
            }
            this.platform.sendLogMessage("Configuration saved to " + this.configFile.getName());
        }
        catch (IOException e) {
            this.platform.sendSevereLogMessage("Failed to save config: " + e.getMessage());
        }
    }

    public int getPort() {
        return Integer.parseInt(this.properties.getOrDefault("port", String.valueOf(8765)));
    }

    public boolean isFallbackEnabled() {
        return Boolean.parseBoolean(this.properties.getOrDefault("fallback-enabled", String.valueOf(true)));
    }

    public int getMaxOfflineHours() {
        String level = this.properties.getOrDefault("security-level", "basic");
        if ("basic".equalsIgnoreCase(level)) {
            return 0;
        }
        return Integer.parseInt(this.properties.getOrDefault("max-offline-hours", String.valueOf(72)));
    }

    public String getUpstreamSessionServer() {
        return this.properties.getOrDefault("upstream-server", DEFAULT_UPSTREAM_SESSION_SERVER);
    }

    public void setUpstreamSessionServer(String server) {
        this.properties.put("upstream-server", server);
    }

    public String getIpAddress() {
        return this.properties.getOrDefault("ip-address", DEFAULT_IP_ADDRESS);
    }

    public void setIpAddress(String ip) {
        this.properties.put("ip-address", ip);
    }

    public int getCleanupDays() {
        return Integer.parseInt(this.properties.getOrDefault("cleanup-days", String.valueOf(30)));
    }

    public String getSecurityLevel() {
        return this.properties.getOrDefault("security-level", "basic");
    }

    public void setPort(int port) {
        this.properties.put("port", String.valueOf(port));
    }

    public void setFallbackEnabled(boolean enabled) {
        this.properties.put("fallback-enabled", String.valueOf(enabled));
    }

    public void setMaxOfflineHours(int hours) {
        this.properties.put("max-offline-hours", String.valueOf(hours));
    }

    public void setSecurityLevel(String level) {
        if ("basic".equalsIgnoreCase(level) || "medium".equalsIgnoreCase(level)) {
            this.properties.put("security-level", level.toLowerCase());
        }
    }

    public void setCleanupDays(int days) {
        this.properties.put("cleanup-days", String.valueOf(days));
    }

    public String getSessionServerUrl() {
        return "http://" + this.getIpAddress() + ":" + this.getPort();
    }

    public String getDatabaseType() {
        return this.properties.getOrDefault("database.type", DEFAULT_DB_TYPE);
    }

    public String getDatabaseHost() {
        return this.properties.getOrDefault("database.host", DEFAULT_DB_HOST);
    }

    public int getDatabasePort() {
        String dbType = this.getDatabaseType();
        int defaultPort = dbType.equalsIgnoreCase("postgresql") ? 5432 : 3306;
        return Integer.parseInt(this.properties.getOrDefault("database.port", String.valueOf(defaultPort)));
    }

    public String getDatabaseName() {
        return this.properties.getOrDefault("database.name", DEFAULT_DB_NAME);
    }

    public String getDatabaseUsername() {
        return this.properties.getOrDefault("database.username", DEFAULT_DB_USERNAME);
    }

    public String getDatabasePassword() {
        return this.properties.getOrDefault("database.password", DEFAULT_DB_PASSWORD);
    }

    public void setDatabaseType(String type) {
        if ("sqlite".equalsIgnoreCase(type) || "mysql".equalsIgnoreCase(type) || "mariadb".equalsIgnoreCase(type) || "postgresql".equalsIgnoreCase(type)) {
            this.properties.put("database.type", type.toLowerCase());
        }
    }

    public void setDatabaseHost(String host) {
        this.properties.put("database.host", host);
    }

    public void setDatabasePort(int port) {
        this.properties.put("database.port", String.valueOf(port));
    }

    public void setDatabaseName(String name) {
        this.properties.put("database.name", name);
    }

    public void setDatabaseUsername(String username) {
        this.properties.put("database.username", username);
    }

    public void setDatabasePassword(String password) {
        this.properties.put("database.password", password);
    }

    public boolean isRemoteDatabase() {
        return !this.getDatabaseType().equalsIgnoreCase(DEFAULT_DB_TYPE);
    }

    public String toString() {
        return "SessionConfig{ip-address=" + this.getIpAddress() + ", port=" + this.getPort() + ", fallbackEnabled=" + this.isFallbackEnabled() + ", securityLevel=" + this.getSecurityLevel() + ", upstream-server=" + this.getUpstreamSessionServer() + ", maxOfflineHours=" + this.getMaxOfflineHours() + ", cleanupDays=" + this.getCleanupDays() + ", databaseType=" + this.getDatabaseType() + ", databaseHost=" + this.getDatabaseHost() + ", databasePort=" + this.getDatabasePort() + "}";
    }
}

