/*
 * Decompiled with CFR 0.152.
 */
package me.gamerduck.alwaysauth.api;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import me.gamerduck.alwaysauth.Platform;
import me.gamerduck.alwaysauth.api.AuthDatabase;
import me.gamerduck.alwaysauth.api.SessionConfig;

public class SessionProxyServer {
    private static final int UPSTREAM_TIMEOUT_MS = 3000;
    private final HttpServer server;
    private final AuthDatabase database;
    private final Gson gson;
    private final SessionConfig config;
    private final Platform platform;
    private final String upstreamSessionServer;

    public AuthDatabase getDatabase() {
        return this.database;
    }

    public SessionProxyServer(int port, File dataFolder, Platform platform, SessionConfig config) throws IOException {
        this.platform = platform;
        this.gson = new Gson();
        this.config = config;
        this.database = config.isRemoteDatabase() ? new AuthDatabase(config.getDatabaseHost(), config.getDatabasePort(), config.getDatabaseName(), config.getDatabaseUsername(), config.getDatabasePassword(), config.getDatabaseType(), platform) : new AuthDatabase(new File(dataFolder, "authcache.db"), platform);
        this.upstreamSessionServer = config.getUpstreamSessionServer();
        this.server = HttpServer.create(new InetSocketAddress(config.getIpAddress(), port), 0);
        this.server.createContext("/session/minecraft/hasJoined", this::handleHasJoined);
        this.server.createContext("/session/minecraft/join", this::handleJoin);
        this.server.setExecutor(Executors.newVirtualThreadPerTaskExecutor());
        platform.sendLogMessage("Session proxy server created on port " + port);
    }

    public void start() {
        this.server.start();
        this.platform.sendLogMessage("Session proxy server started");
    }

    public void stop() {
        this.server.stop(0);
        this.database.close();
        this.platform.sendLogMessage("Session proxy server stopped");
    }

    private void handleHasJoined(HttpExchange exchange) throws IOException {
        try {
            String query = exchange.getRequestURI().getQuery();
            QueryParams params = this.parseQuery(query);
            String username = params.get("username");
            String serverId = params.get("serverId");
            String ip = params.get("ip");
            if (username == null || serverId == null) {
                this.sendResponse(exchange, 400, "Missing parameters");
                return;
            }
            this.platform.sendLogMessage("Authentication request for user: " + username + " (serverId: " + serverId + ")");
            try {
                String upstreamResponse = this.forwardToUpstream("/session/minecraft/hasJoined", query);
                if (upstreamResponse != null && !upstreamResponse.isEmpty()) {
                    JsonObject profile = (JsonObject)this.gson.fromJson(upstreamResponse, JsonObject.class);
                    this.database.cacheAuthentication(username, ip, profile);
                    this.platform.sendLogMessage("Successfully authenticated " + username + " via Upstream");
                }
                this.sendResponse(exchange, 200, upstreamResponse);
                return;
            }
            catch (Exception e) {
                this.platform.sendWarningLogMessage("Upstream authentication failed for " + username + ": " + e.getMessage());
                if (this.config.isFallbackEnabled()) {
                    String fallbackResponse = this.database.getFallbackAuth(username, ip, this.config.getMaxOfflineHours());
                    if (fallbackResponse != null) {
                        this.platform.sendWarningLogMessage("Using FALLBACK authentication for " + username);
                        this.sendResponse(exchange, 200, fallbackResponse);
                        return;
                    }
                    this.platform.sendWarningLogMessage("Fallback authentication failed for " + username + " - no cached data or IP mismatch");
                }
                this.sendResponse(exchange, 204, "");
            }
        }
        catch (Exception e) {
            this.platform.sendSevereLogMessage("Error handling hasJoined: " + e.getMessage());
            e.printStackTrace();
            this.sendResponse(exchange, 500, "Internal server error");
        }
    }

    private void handleJoin(HttpExchange exchange) throws IOException {
        try {
            String body = this.readRequestBody(exchange);
            String response = this.forwardToUpstreamPost("/session/minecraft/join", body);
            this.sendResponse(exchange, response != null ? 204 : 500, response != null ? "" : "Failed");
        }
        catch (Exception e) {
            this.platform.sendWarningLogMessage("Error forwarding join request: " + e.getMessage());
            this.sendResponse(exchange, 500, "Internal server error");
        }
    }

    private String forwardToUpstream(String endpoint, String query) throws IOException {
        URL url = new URL(this.upstreamSessionServer + endpoint + "?" + query);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setConnectTimeout(3000);
        conn.setReadTimeout(3000);
        int responseCode = conn.getResponseCode();
        if (responseCode == 200) {
            return this.readInputStream(conn.getInputStream());
        }
        if (responseCode == 204) {
            return "";
        }
        throw new IOException("Upstream returned status: " + responseCode);
    }

    private String forwardToUpstreamPost(String endpoint, String body) throws IOException {
        URL url = new URL(this.upstreamSessionServer + endpoint);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.setConnectTimeout(3000);
        conn.setReadTimeout(3000);
        conn.setRequestProperty("Content-Type", "application/json");
        try (OutputStream os = conn.getOutputStream();){
            os.write(body.getBytes(StandardCharsets.UTF_8));
        }
        int responseCode = conn.getResponseCode();
        if (responseCode == 204) {
            return "";
        }
        throw new IOException("Upstream returned status: " + responseCode);
    }

    private void sendResponse(HttpExchange exchange, int statusCode, String response) throws IOException {
        byte[] bytes = response.getBytes(StandardCharsets.UTF_8);
        exchange.sendResponseHeaders(statusCode, statusCode == 204 ? -1L : (long)bytes.length);
        if (statusCode != 204 && bytes.length > 0) {
            try (OutputStream os = exchange.getResponseBody();){
                os.write(bytes);
            }
        }
        exchange.close();
    }

    private String readInputStream(InputStream is) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            String string = sb.toString();
            return string;
        }
    }

    private String readRequestBody(HttpExchange exchange) throws IOException {
        return this.readInputStream(exchange.getRequestBody());
    }

    private QueryParams parseQuery(String query) {
        QueryParams params = new QueryParams();
        if (query == null) {
            return params;
        }
        for (String param : query.split("&")) {
            String[] pair = param.split("=", 2);
            if (pair.length != 2) continue;
            try {
                params.put(pair[0], URLDecoder.decode(pair[1], "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return params;
    }

    private static class QueryParams {
        private final Map<String, String> params = new HashMap<String, String>();

        private QueryParams() {
        }

        void put(String key, String value) {
            this.params.put(key, value);
        }

        String get(String key) {
            return this.params.get(key);
        }
    }
}

