/*
 * Decompiled with CFR 0.152.
 */
package edivad.edivadlib.compat.top;

import edivad.edivadlib.compat.top.TOPElement;
import edivad.edivadlib.tools.utils.FluidUtils;
import java.text.DecimalFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public abstract class FluidElement
extends TOPElement {
    protected final FluidStack fluid;
    protected final int capacity;
    protected final int colorLiquid;

    protected FluidElement(FluidStack fluid, int capacity, int colorLiquid) {
        super(-16777216, 0xFFFFFF);
        this.fluid = fluid;
        this.capacity = capacity;
        this.colorLiquid = colorLiquid;
    }

    public FluidElement(FluidStack fluid, int capacity, BlockEntity blockentity) {
        this(fluid, capacity, FluidUtils.getLiquidColorWithBiome(fluid, blockentity));
    }

    public FluidElement(RegistryFriendlyByteBuf buf) {
        this((FluidStack)FluidStack.OPTIONAL_STREAM_CODEC.decode((Object)buf), buf.readInt(), buf.readInt());
    }

    public void toBytes(RegistryFriendlyByteBuf buf) {
        FluidStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)this.fluid);
        buf.writeInt(this.capacity);
        buf.writeInt(this.colorLiquid);
    }

    @Override
    public int getScaledLevel(int level) {
        if (this.capacity == 0 || this.fluid.getAmount() == Integer.MAX_VALUE) {
            return level;
        }
        long fluidAmount = this.fluid.getAmount();
        long result = fluidAmount * (long)level / (long)this.capacity;
        return (int)result;
    }

    @Override
    @Nullable
    public TextureAtlasSprite getIcon() {
        return this.fluid.isEmpty() ? null : FluidUtils.getFluidTexture(this.fluid);
    }

    @Override
    public MutableComponent getText() {
        String liquidText = this.fluid.isEmpty() ? "Empty" : this.fluid.getHoverName().getString();
        DecimalFormat f = new DecimalFormat("#,##0");
        int amount = this.fluid.getAmount();
        return Component.literal((String)String.format("%s: %smB", liquidText, f.format(amount)));
    }

    @Override
    protected boolean applyRenderColor(GuiGraphics guiGraphics) {
        FluidUtils.color(guiGraphics, this.colorLiquid);
        return true;
    }
}

