/*
 * Decompiled with CFR 0.152.
 */
package edivad.edivadlib.tools.utils;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.data.AtlasIds;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.NotImplementedException;

public class FluidUtils {
    public static float getRed(int color) {
        return (float)ARGB.red((int)color) / 255.0f;
    }

    public static float getGreen(int color) {
        return (float)ARGB.green((int)color) / 255.0f;
    }

    public static float getBlue(int color) {
        return (float)ARGB.blue((int)color) / 255.0f;
    }

    public static float getAlpha(int color) {
        return (float)ARGB.alpha((int)color) / 255.0f;
    }

    public static void color(GuiGraphics guiGraphics, int color) {
        throw new NotImplementedException();
    }

    public static TextureAtlasSprite getFluidTexture(FluidStack fluidStack) {
        IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        ResourceLocation stillTexture = extensions.getStillTexture(fluidStack);
        return Minecraft.getInstance().getAtlasManager().getAtlasOrThrow(AtlasIds.BLOCKS).getSprite(stillTexture);
    }

    public static int getLiquidColorWithBiome(FluidStack fluidStack, Level level, BlockPos pos) {
        if (level.isClientSide() && fluidStack.getFluid().isSame((Fluid)Fluids.WATER)) {
            return BiomeColors.getAverageWaterColor((BlockAndTintGetter)level, (BlockPos)pos) | 0xFF000000;
        }
        return IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getTintColor(fluidStack);
    }

    public static int getLiquidColorWithBiome(FluidStack fluid, BlockEntity blockEntity) {
        return FluidUtils.getLiquidColorWithBiome(fluid, Objects.requireNonNull(blockEntity.getLevel()), blockEntity.getBlockPos());
    }

    public static int getFluidScaled(int pixels, FluidStack fluid, int maxLiquidAmount) {
        if (maxLiquidAmount == 0) {
            return pixels;
        }
        long currentLiquidAmount = fluid.getAmount();
        long x = currentLiquidAmount * (long)pixels / (long)maxLiquidAmount;
        return pixels - (int)x;
    }
}

