/*
 * Decompiled with CFR 0.152.
 */
package edivad.edivadlib.compat.top;

import mcjty.theoneprobe.api.IElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;

public abstract class TOPElement
implements IElement {
    private final int borderColor;
    private final int textColor;

    protected TOPElement(int borderColor, int textColor) {
        this.borderColor = borderColor;
        this.textColor = textColor;
    }

    protected static void renderScaledText(GuiGraphics guiGraphics, Font font, int x, int y, int color, int maxWidth, MutableComponent component) {
        String text = component.getString();
        int length = font.width(text);
        if (length <= maxWidth) {
            guiGraphics.drawString(font, text, x, y, color);
        } else {
            float scale = (float)maxWidth / (float)length;
            float reverse = 1.0f / scale;
            float yAdd = 4.0f - scale * 8.0f / 2.0f;
            Matrix3x2fStack poseStack = guiGraphics.pose();
            poseStack.pushMatrix();
            poseStack.scale(scale, scale, (Matrix3x2f)poseStack);
            guiGraphics.drawString(font, text, (int)((float)x * reverse), (int)((float)y * reverse + yAdd), color);
            poseStack.popMatrix();
        }
    }

    public void render(GuiGraphics guiGraphics, int x, int y) {
        boolean colored;
        int scale;
        int width = this.getWidth();
        int height = this.getHeight();
        guiGraphics.fill(x, y, x + width - 1, y + 1, this.borderColor);
        guiGraphics.fill(x, y, x + 1, y + height - 1, this.borderColor);
        guiGraphics.fill(x + width - 1, y, x + width, y + height - 1, this.borderColor);
        guiGraphics.fill(x, y + height - 1, x + width, y + height, this.borderColor);
        TextureAtlasSprite icon = this.getIcon();
        if (icon == null || (scale = this.getScaledLevel(width - 2)) <= 0 || (colored = this.applyRenderColor(guiGraphics))) {
            // empty if block
        }
        TOPElement.renderScaledText(guiGraphics, Minecraft.getInstance().font, x + 4, y + 3, this.textColor, this.getWidth() - 8, this.getText());
    }

    public int getWidth() {
        return 100;
    }

    public int getHeight() {
        return 13;
    }

    public abstract int getScaledLevel(int var1);

    @Nullable
    public abstract TextureAtlasSprite getIcon();

    public abstract MutableComponent getText();

    protected boolean applyRenderColor(GuiGraphics guiGraphics) {
        return false;
    }
}

