/*
 * Decompiled with CFR 0.152.
 */
package io.github.pistonpoek.magicalscepter.command;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import io.github.pistonpoek.magicalscepter.command.argument.ModRegistryEntryReferenceArgumentType;
import io.github.pistonpoek.magicalscepter.registry.ModRegistryKeys;
import io.github.pistonpoek.magicalscepter.spell.Spell;
import io.github.pistonpoek.magicalscepter.spell.cast.delay.SpellCastingManager;
import io.github.pistonpoek.magicalscepter.util.ModIdentifier;
import java.util.Collection;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7733;

public class SpellCommand {
    private static final SimpleCommandExceptionType CAST_FAILED_EXCEPTION = new SimpleCommandExceptionType((Message)ModIdentifier.translatable("commands.spell.cast.failed", new Object[0]));
    private static final SimpleCommandExceptionType CLEAR_FAILED_EXCEPTION = new SimpleCommandExceptionType((Message)ModIdentifier.translatable("commands.spell.clear.failed", new Object[0]));

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"spell").requires(source -> source.method_9259(2))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").executes(context -> SpellCommand.executeClear((class_2168)context.getSource(), (Collection<? extends class_1297>)ImmutableList.of((Object)((class_2168)context.getSource()).method_9229())))).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).executes(context -> SpellCommand.executeClear((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)"targets")))))).then(class_2170.method_9247((String)"cast").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).then(class_2170.method_9244((String)"spell", (ArgumentType)class_7733.method_45603((class_7157)registryAccess, ModRegistryKeys.SPELL)).executes(context -> SpellCommand.executeCast((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)"targets"), ModRegistryEntryReferenceArgumentType.getSpell((CommandContext<class_2168>)context, "spell")))))));
    }

    private static int executeCast(class_2168 source, Collection<? extends class_1297> entities, class_6880<Spell> spell) throws CommandSyntaxException {
        Spell spellInstance = (Spell)spell.comp_349();
        int successes = 0;
        for (class_1297 class_12972 : entities) {
            if (!(class_12972 instanceof class_1309)) continue;
            class_1309 livingEntity = (class_1309)class_12972;
            spellInstance.castSpell(livingEntity);
            ++successes;
        }
        if (successes == 0) {
            throw CAST_FAILED_EXCEPTION.create();
        }
        if (entities.size() == 1) {
            source.method_9226(() -> ModIdentifier.translatable("commands.spell.cast.success.single", Spell.getName(spell), ((class_1297)entities.iterator().next()).method_5476()), true);
        } else {
            source.method_9226(() -> ModIdentifier.translatable("commands.spell.cast.success.multiple", Spell.getName(spell), entities.size()), true);
        }
        return successes;
    }

    private static int executeClear(class_2168 source, Collection<? extends class_1297> entities) throws CommandSyntaxException {
        int successes = 0;
        for (class_1297 class_12972 : entities) {
            class_1309 livingEntity;
            if (!(class_12972 instanceof class_1309) || !SpellCastingManager.clear(livingEntity = (class_1309)class_12972)) continue;
            ++successes;
        }
        if (successes == 0) {
            throw CLEAR_FAILED_EXCEPTION.create();
        }
        if (entities.size() == 1) {
            source.method_9226(() -> ModIdentifier.translatable("commands.spell.clear.success.single", ((class_1297)entities.iterator().next()).method_5476()), true);
        } else {
            source.method_9226(() -> ModIdentifier.translatable("commands.spell.clear.success.multiple", entities.size()), true);
        }
        return successes;
    }
}

