/*
 * Decompiled with CFR 0.152.
 */
package io.github.pistonpoek.magicalscepter.item;

import io.github.pistonpoek.magicalscepter.advancement.criterion.ModCriteria;
import io.github.pistonpoek.magicalscepter.component.ModDataComponentTypes;
import io.github.pistonpoek.magicalscepter.component.ScepterContentsComponent;
import io.github.pistonpoek.magicalscepter.item.AttackItem;
import io.github.pistonpoek.magicalscepter.item.ModItems;
import io.github.pistonpoek.magicalscepter.item.SwingHandLivingEntity;
import io.github.pistonpoek.magicalscepter.item.SwingType;
import io.github.pistonpoek.magicalscepter.scepter.ScepterHelper;
import io.github.pistonpoek.magicalscepter.sound.ModSoundEvents;
import io.github.pistonpoek.magicalscepter.spell.Spell;
import io.github.pistonpoek.magicalscepter.util.ModIdentifier;
import io.github.pistonpoek.magicalscepter.util.PlayerExperience;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public class MagicalScepterItem
extends class_1792
implements AttackItem {
    public MagicalScepterItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        return this.performAction(world, user, hand, false);
    }

    @Override
    public class_1269 attack(class_1937 world, class_1657 user) {
        return this.performAction(world, user, class_1268.field_5808, true);
    }

    private class_1269 performAction(class_1937 world, class_1657 user, class_1268 hand, boolean isAttack) {
        class_1799 itemStack = user.method_5998(hand);
        ScepterContentsComponent scepterContent = ScepterContentsComponent.get(itemStack).orElse(ScepterContentsComponent.DEFAULT);
        Optional<Spell> optionalSpell = (isAttack ? scepterContent.getAttackSpell() : scepterContent.getProtectSpell()).map(class_6880::comp_349);
        if (optionalSpell.isEmpty()) {
            return class_1269.field_5811;
        }
        Spell spell = optionalSpell.get();
        if (!user.method_31549().field_7477) {
            if (!scepterContent.hasEnoughExperience(user)) {
                return class_1269.field_5811;
            }
            int experienceCost = scepterContent.getExperienceCost();
            PlayerExperience.addOnlyExperience(user, -experienceCost);
        }
        user.method_6019(hand);
        user.method_7357().method_62835(itemStack, user.method_31549().field_7477 ? 10 : spell.getCooldown());
        user.method_7259(class_3468.field_15372.method_14956((Object)this));
        class_1799 usedScepterStack = MagicalScepterItem.castSpell(spell, (class_1309)user, itemStack, isAttack, hand);
        return class_1269.field_21466.method_61393(usedScepterStack);
    }

    public static class_1799 castSpell(@NotNull Spell spell, @NotNull class_1309 caster, @NotNull class_1799 itemStack, boolean isAttack, class_1268 hand) {
        caster.method_56078(isAttack ? ModSoundEvents.ITEM_MAGICAL_SCEPTER_CAST_ATTACK_SPELL : ModSoundEvents.ITEM_MAGICAL_SCEPTER_CAST_PROTECT_SPELL);
        SwingType swingType = isAttack ? SwingType.HIT : SwingType.PROTECT;
        ((SwingHandLivingEntity)caster).magical_scepter$swingHand(hand, swingType);
        if (caster.method_73183().method_8608()) {
            return itemStack;
        }
        if (caster instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)caster;
            ModCriteria.CAST_SCEPTER.trigger(serverPlayerEntity, itemStack);
        }
        spell.castSpell(caster);
        class_1799 replacementStack = class_1799.field_8037;
        if (itemStack.method_63692() && itemStack.method_31574(ModItems.MAGICAL_SCEPTER)) {
            replacementStack = ScepterHelper.createScepter(itemStack);
            replacementStack.method_7974(0);
        }
        itemStack.method_7970(1, caster, hand.method_73186());
        return !itemStack.method_7960() ? itemStack : replacementStack;
    }

    public class_2561 method_7864(class_1799 stack) {
        ScepterContentsComponent scepterContentsComponent = (ScepterContentsComponent)stack.method_58694(ModDataComponentTypes.SCEPTER_CONTENTS);
        return scepterContentsComponent != null ? ModIdentifier.translatable(this.method_7876() + "." + scepterContentsComponent.getTranslationKey(), new Object[0]) : super.method_7864(stack);
    }
}

