/*
 * Decompiled with CFR 0.152.
 */
package io.github.pistonpoek.magicalscepter.spell;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.pistonpoek.magicalscepter.registry.ModRegistryKeys;
import io.github.pistonpoek.magicalscepter.spell.cast.SpellCast;
import io.github.pistonpoek.magicalscepter.world.event.ModGameEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_6899;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public record Spell(List<SpellCast> casts, int cooldown, class_2561 description) {
    public static final Codec<Spell> BASE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SpellCast.CODEC.listOf().fieldOf("casts").forGetter(Spell::casts), (App)class_5699.field_33441.fieldOf("cooldown").forGetter(Spell::cooldown), (App)class_8824.field_46597.fieldOf("description").forGetter(Spell::description)).apply((Applicative)instance, Spell::new));
    public static final Codec<Spell> NETWORK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("cooldown").forGetter(Spell::cooldown), (App)class_8824.field_46597.fieldOf("description").forGetter(Spell::description)).apply((Applicative)instance, Spell::createClientSpell));
    public static final Codec<class_6880<Spell>> ENTRY_CODEC = class_6899.method_40400(ModRegistryKeys.SPELL);
    public static final Codec<Spell> CODEC = Codec.withAlternative(BASE_CODEC, ENTRY_CODEC, class_6880::comp_349);
    public static final class_9139<class_9129, class_6880<Spell>> ENTRY_PACKET_CODEC = class_9135.method_56383(ModRegistryKeys.SPELL);
    public static final class_9139<class_9129, Spell> PACKET_CODEC = class_9135.method_56896(CODEC);

    private static Spell createClientSpell(int cooldown, class_2561 description) {
        return new Spell(List.of(), cooldown, description);
    }

    public void castSpell(@NotNull class_1309 caster) {
        if (caster.method_73183().method_8608()) {
            return;
        }
        for (SpellCast cast : this.casts) {
            cast.invoke(caster);
        }
        caster.method_32876(ModGameEvent.SPELL_CAST);
    }

    public int getCooldown() {
        return this.cooldown;
    }

    @Override
    public String toString() {
        return "Spell " + this.description.getString();
    }

    public static class_5250 getName(class_6880<Spell> spell) {
        return ((Spell)spell.comp_349()).description.method_27661();
    }

    public static Builder builder(int cooldown, class_2561 description) {
        return new Builder(cooldown, description);
    }

    public static class Builder {
        private final int cooldown;
        private final class_2561 description;
        private final List<SpellCast> casts = new ArrayList<SpellCast>();

        public Builder(int cooldown, class_2561 description) {
            this.cooldown = cooldown;
            this.description = description;
        }

        public Builder addCast(SpellCast.Builder cast) {
            this.casts.add(cast.build());
            return this;
        }

        public Spell build() {
            return new Spell(this.casts, this.cooldown, this.description);
        }
    }
}

