/*
 * Decompiled with CFR 0.152.
 */
package io.github.pistonpoek.magicalscepter.spell.cast;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.pistonpoek.magicalscepter.spell.cast.context.SpellCasting;
import io.github.pistonpoek.magicalscepter.spell.cast.transformer.CastTransformer;
import io.github.pistonpoek.magicalscepter.spell.effect.SpellEffect;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1309;
import org.jetbrains.annotations.NotNull;

public record SpellCast(List<SpellEffect> effects, List<CastTransformer> transformers) {
    public static final Codec<SpellCast> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SpellEffect.CODEC.listOf().fieldOf("effects").forGetter(SpellCast::effects), (App)CastTransformer.CODEC.listOf().optionalFieldOf("transformers", new ArrayList()).forGetter(SpellCast::transformers)).apply((Applicative)instance, SpellCast::new));

    public void invoke(@NotNull class_1309 caster) {
        new SpellCasting(this, caster).invoke();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<SpellEffect> effects = new ArrayList<SpellEffect>();
        private final List<CastTransformer> transformers = new ArrayList<CastTransformer>();

        public Builder addEffect(SpellEffect effect) {
            this.effects.add(effect);
            return this;
        }

        public Builder addTransformer(CastTransformer transformer) {
            this.transformers.add(transformer);
            return this;
        }

        public SpellCast build() {
            return new SpellCast(this.effects, this.transformers);
        }
    }
}

